/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.last;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongLastAggregator
implements Aggregator {
    private final LongColumnSelector valueSelector;
    private final LongColumnSelector timeSelector;
    private final String name;
    protected long lastTime;
    protected long lastValue;

    public LongLastAggregator(String name, LongColumnSelector timeSelector, LongColumnSelector valueSelector) {
        this.name = name;
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.reset();
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time >= this.lastTime) {
            this.lastTime = time;
            this.lastValue = this.valueSelector.getLong();
        }
    }

    @Override
    public void reset() {
        this.lastTime = Long.MIN_VALUE;
        this.lastValue = 0L;
    }

    @Override
    public double getDouble() {
        return this.lastValue;
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Long>(this.lastTime, this.lastValue);
    }

    @Override
    public float getFloat() {
        return this.lastValue;
    }

    @Override
    public long getLong() {
        return this.lastValue;
    }

    @Override
    public void close() {
    }
}

