/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.FloatFirstAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.first.LongFirstAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.last.FloatLastAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.last.FloatLastBufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.FloatColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class FloatLastAggregatorFactory
extends AggregatorFactory {
    private final String fieldName;
    private final String name;

    @JsonCreator
    public FloatLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldName, "Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = metricFactory.makeFloatColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new FloatLastAggregator(this.name, metricFactory.makeLongColumnSelector("__time"), floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        FloatColumnSelector floatColumnSelector = metricFactory.makeFloatColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new FloatLastBufferAggregator(metricFactory.makeLongColumnSelector("__time"), floatColumnSelector), (ColumnValueSelector)floatColumnSelector);
    }

    @Override
    public Comparator getComparator() {
        return FloatFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return FloatFirstAggregatorFactory.TIME_COMPARATOR.compare(lhs, rhs) > 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("FloatLastAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatLastAggregatorFactory(this.name, this.name){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(FloatLastAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new FloatLastAggregator(FloatLastAggregatorFactory.this.name, null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.get();
                        if ((Long)pair.lhs >= this.lastTime) {
                            this.lastTime = (Long)pair.lhs;
                            this.lastValue = ((Float)pair.rhs).floatValue();
                        }
                    }
                }, (ColumnValueSelector)selector);
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(FloatLastAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new FloatLastBufferAggregator(null, null){

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.get();
                        long lastTime = buf.getLong(position);
                        if ((Long)pair.lhs >= lastTime) {
                            buf.putLong(position, (Long)pair.lhs);
                            buf.putFloat(position + 8, ((Float)pair.rhs).floatValue());
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                }, (ColumnValueSelector)selector);
            }
        };
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new LongFirstAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePair<Long, Float>(((Number)map.get("lhs")).longValue(), Float.valueOf(((Number)map.get("rhs")).floatValue()));
    }

    @Override
    @Nullable
    public Object finalizeComputation(Object object) {
        return object == null ? null : (Float)((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8(this.fieldName);
        return ByteBuffer.allocate(2 + fieldNameBytes.length).put((byte)17).put(fieldNameBytes).put((byte)-1).array();
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 12 + NullHandlingHelper.extraAggregatorBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatLastAggregatorFactory that = (FloatLastAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }

    public String toString() {
        return "FloatLastAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

