/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.hll.HyperLogLogHash;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.IOPeon;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricExtractor;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;

public class HyperUniquesSerde
extends ComplexMetricSerde {
    private static Ordering<HyperLogLogCollector> comparator = new Ordering<HyperLogLogCollector>(){

        @Override
        public int compare(HyperLogLogCollector arg1, HyperLogLogCollector arg2) {
            return arg1.toByteBuffer().compareTo(arg2.toByteBuffer());
        }
    }.nullsFirst();
    private final HyperLogLogHash hyperLogLogHash;

    public HyperUniquesSerde(HyperLogLogHash hyperLogLogHash) {
        this.hyperLogLogHash = hyperLogLogHash;
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                List<String> dimValues = inputRow.getDimension(metricName);
                if (dimValues == null) {
                    return collector;
                }
                for (String dimensionValue : dimValues) {
                    collector.add(HyperUniquesSerde.this.hyperLogLogHash.hash(dimensionValue));
                }
                return collector;
            }
        };
    }

    @Override
    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = GenericIndexed.read(byteBuffer, this.getObjectStrategy());
        columnBuilder.setComplexColumn(new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    @Override
    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<HyperLogLogCollector>(){

            @Override
            public Class<? extends HyperLogLogCollector> getClazz() {
                return HyperLogLogCollector.class;
            }

            @Override
            public HyperLogLogCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
                return HyperLogLogCollector.makeCollector(readOnlyBuffer);
            }

            @Override
            public byte[] toBytes(HyperLogLogCollector collector) {
                if (collector == null) {
                    return new byte[0];
                }
                ByteBuffer val = collector.toByteBuffer();
                byte[] retVal = new byte[val.remaining()];
                val.asReadOnlyBuffer().get(retVal);
                return retVal;
            }

            @Override
            public int compare(HyperLogLogCollector o1, HyperLogLogCollector o2) {
                return comparator.compare(o1, o2);
            }
        };
    }

    @Override
    public GenericColumnSerializer getSerializer(IOPeon peon, String column) {
        return LargeColumnSupportedComplexColumnSerializer.create(peon, column, this.getObjectStrategy());
    }
}

