/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.DoubleFirstAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.first.LongFirstAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.LongFirstBufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;
import org.apache.hive.druid.io.druid.segment.NullHandlingHelper;
import org.apache.hive.druid.io.druid.segment.ObjectColumnSelector;

public class LongFirstAggregatorFactory
extends AggregatorFactory {
    public static final Comparator VALUE_COMPARATOR = (o1, o2) -> Longs.compare((Long)((SerializablePair)o1).rhs, (Long)((SerializablePair)o2).rhs);
    private final String fieldName;
    private final String name;

    @JsonCreator
    public LongFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldName, "Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        LongColumnSelector longColumnSelector = metricFactory.makeLongColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new LongFirstAggregator(this.name, metricFactory.makeLongColumnSelector("__time"), longColumnSelector), (ColumnValueSelector)longColumnSelector);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        LongColumnSelector longColumnSelector = metricFactory.makeLongColumnSelector(this.fieldName);
        return NullHandlingHelper.getNullableAggregator(new LongFirstBufferAggregator(metricFactory.makeLongColumnSelector("__time"), longColumnSelector), (ColumnValueSelector)longColumnSelector);
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        return DoubleFirstAggregatorFactory.TIME_COMPARATOR.compare(lhs, rhs) <= 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("LongFirstAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongFirstAggregatorFactory(this.name, this.name){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(LongFirstAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new LongFirstAggregator(LongFirstAggregatorFactory.this.name, null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.get();
                        if ((Long)pair.lhs < this.firstTime) {
                            this.firstTime = (Long)pair.lhs;
                            this.firstValue = (Long)pair.rhs;
                        }
                    }
                }, (ColumnValueSelector)selector);
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(LongFirstAggregatorFactory.this.name);
                return NullHandlingHelper.getNullableAggregator(new LongFirstBufferAggregator(null, null){

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.get();
                        long firstTime = buf.getLong(position);
                        if ((Long)pair.lhs < firstTime) {
                            buf.putLong(position, (Long)pair.lhs);
                            buf.putLong(position + 8, (Long)pair.rhs);
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                }, (ColumnValueSelector)selector);
            }
        };
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new LongFirstAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePair<Long, Long>(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).longValue());
    }

    @Override
    @Nullable
    public Object finalizeComputation(Object object) {
        return object == null ? object : ((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8(this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)23).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "long";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 16 + NullHandlingHelper.extraAggregatorBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongFirstAggregatorFactory that = (LongFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }

    public String toString() {
        return "LongFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

