/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class LongFirstAggregator
implements Aggregator {
    private final LongColumnSelector valueSelector;
    private final LongColumnSelector timeSelector;
    private final String name;
    protected long firstTime;
    protected long firstValue;

    public LongFirstAggregator(String name, LongColumnSelector timeSelector, LongColumnSelector valueSelector) {
        this.name = name;
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.reset();
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getLong();
        }
    }

    @Override
    public void reset() {
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0L;
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Long>(this.firstTime, this.firstValue);
    }

    @Override
    public float getFloat() {
        return this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return this.firstValue;
    }

    @Override
    public void close() {
    }
}

