/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSelector;
import org.apache.hive.druid.io.druid.segment.LongColumnSelector;

public class DoubleFirstAggregator
implements Aggregator {
    private final DoubleColumnSelector valueSelector;
    private final LongColumnSelector timeSelector;
    private final String name;
    protected long firstTime;
    protected double firstValue;

    public DoubleFirstAggregator(String name, LongColumnSelector timeSelector, DoubleColumnSelector valueSelector) {
        this.name = name;
        this.valueSelector = valueSelector;
        this.timeSelector = timeSelector;
        this.reset();
    }

    @Override
    public void aggregate() {
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            this.firstValue = this.valueSelector.getDouble();
        }
    }

    @Override
    public void reset() {
        this.firstTime = Long.MAX_VALUE;
        this.firstValue = 0.0;
    }

    @Override
    public Object get() {
        return new SerializablePair<Long, Double>(this.firstTime, this.firstValue);
    }

    @Override
    public float getFloat() {
        return (float)this.firstValue;
    }

    @Override
    public double getDouble() {
        return this.firstValue;
    }

    @Override
    public long getLong() {
        return (long)this.firstValue;
    }

    @Override
    public void close() {
    }
}

