/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;

public abstract class BaseQuery<T extends Comparable<T>>
implements Query<T> {
    public static final String QUERYID = "queryId";
    private final DataSource dataSource;
    private final boolean descending;
    private final Map<String, Object> context;
    private final QuerySegmentSpec querySegmentSpec;
    private volatile Duration duration;

    public static void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new QueryInterruptedException(new InterruptedException());
        }
    }

    public BaseQuery(DataSource dataSource, QuerySegmentSpec querySegmentSpec, boolean descending, Map<String, Object> context) {
        Preconditions.checkNotNull(dataSource, "dataSource can't be null");
        Preconditions.checkNotNull(querySegmentSpec, "querySegmentSpec can't be null");
        this.dataSource = dataSource;
        this.context = context;
        this.querySegmentSpec = querySegmentSpec;
        this.descending = descending;
    }

    @Override
    @JsonProperty
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    public boolean isDescending() {
        return this.descending;
    }

    @JsonProperty(value="intervals")
    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    @Override
    public Sequence<T> run(QuerySegmentWalker walker, Map<String, Object> context) {
        return this.run(this.querySegmentSpec.lookup(this, walker), context);
    }

    @Override
    public Sequence<T> run(QueryRunner<T> runner, Map<String, Object> context) {
        return runner.run(this, context);
    }

    @Override
    public List<Interval> getIntervals() {
        return this.querySegmentSpec.getIntervals();
    }

    @Override
    public Duration getDuration() {
        if (this.duration == null) {
            Duration totalDuration = new Duration(0L);
            for (Interval interval : this.querySegmentSpec.getIntervals()) {
                if (interval == null) continue;
                totalDuration = totalDuration.plus((ReadableDuration)interval.toDuration());
            }
            this.duration = totalDuration;
        }
        return this.duration;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public <ContextType> ContextType getContextValue(String key) {
        return (ContextType)(this.context == null ? null : this.context.get(key));
    }

    @Override
    public <ContextType> ContextType getContextValue(String key, ContextType defaultValue) {
        ContextType retVal = this.getContextValue(key);
        return retVal == null ? defaultValue : retVal;
    }

    @Override
    public boolean getContextBoolean(String key, boolean defaultValue) {
        return QueryContexts.parseBoolean(this, key, defaultValue);
    }

    @Deprecated
    protected Map<String, Object> computeOverridenContext(Map<String, Object> overrides) {
        return BaseQuery.computeOverriddenContext(this.getContext(), overrides);
    }

    protected static Map<String, Object> computeOverriddenContext(Map<String, Object> context, Map<String, Object> overrides) {
        TreeMap<String, Object> overridden = Maps.newTreeMap();
        if (context != null) {
            overridden.putAll(context);
        }
        overridden.putAll(overrides);
        return overridden;
    }

    @Override
    public Ordering<T> getResultOrdering() {
        Ordering retVal = Ordering.natural();
        return this.descending ? retVal.reverse() : retVal;
    }

    @Override
    public String getId() {
        return (String)this.getContextValue(QUERYID);
    }

    @Override
    public Query withId(String id) {
        return this.withOverriddenContext(ImmutableMap.of(QUERYID, id));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseQuery baseQuery = (BaseQuery)o;
        if (this.descending != baseQuery.descending) {
            return false;
        }
        if (this.context != null ? !this.context.equals(baseQuery.context) : baseQuery.context != null) {
            return false;
        }
        if (this.dataSource != null ? !this.dataSource.equals(baseQuery.dataSource) : baseQuery.dataSource != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals((Object)baseQuery.duration) : baseQuery.duration != null) {
            return false;
        }
        return !(this.querySegmentSpec != null ? !this.querySegmentSpec.equals(baseQuery.querySegmentSpec) : baseQuery.querySegmentSpec != null);
    }

    public int hashCode() {
        int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
        result = 31 * result + (this.descending ? 1 : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.querySegmentSpec != null ? this.querySegmentSpec.hashCode() : 0);
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        return result;
    }
}

