/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.offheap;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class OffheapBufferGenerator
implements Supplier<ByteBuffer> {
    private static final Logger log = new Logger(OffheapBufferGenerator.class);
    private final String description;
    private final int computationBufferSize;
    private final AtomicLong count = new AtomicLong(0L);

    public OffheapBufferGenerator(String description, int computationBufferSize) {
        this.description = description;
        this.computationBufferSize = computationBufferSize;
    }

    @Override
    public ByteBuffer get() {
        log.info("Allocating new %s buffer[%,d] of size[%,d]", this.description, this.count.getAndIncrement(), this.computationBufferSize);
        return ByteBuffer.allocateDirect(this.computationBufferSize);
    }
}

