/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.math.expr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.math.expr.Expr;

public class ExprMacroTable {
    private static final ExprMacroTable NIL = new ExprMacroTable(Collections.emptyList());
    private final Map<String, ExprMacro> macroMap;

    public ExprMacroTable(List<ExprMacro> macros) {
        this.macroMap = macros.stream().collect(Collectors.toMap(m -> StringUtils.toLowerCase(m.name()), m -> m));
    }

    public static ExprMacroTable nil() {
        return NIL;
    }

    @Nullable
    public Expr get(String functionName, List<Expr> args) {
        ExprMacro exprMacro = this.macroMap.get(StringUtils.toLowerCase(functionName));
        if (exprMacro == null) {
            return null;
        }
        return exprMacro.apply(args);
    }

    public static interface ExprMacro {
        public String name();

        public Expr apply(List<Expr> var1);
    }
}

