/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.parsers;

import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParserUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampParser {
    public static Function<String, DateTime> createTimestampParser(String format) {
        if (format.equalsIgnoreCase("auto")) {
            return new Function<String, DateTime>(){

                @Override
                public DateTime apply(String input) {
                    Preconditions.checkArgument(input != null && !input.isEmpty(), "null timestamp");
                    for (int i = 0; i < input.length(); ++i) {
                        if (input.charAt(i) >= '0' && input.charAt(i) <= '9') continue;
                        return new DateTime((Object)ParserUtils.stripQuotes(input));
                    }
                    return new DateTime(Long.parseLong(input));
                }
            };
        }
        if (format.equalsIgnoreCase("iso")) {
            return new Function<String, DateTime>(){

                @Override
                public DateTime apply(String input) {
                    Preconditions.checkArgument(input != null && !input.isEmpty(), "null timestamp");
                    return new DateTime((Object)ParserUtils.stripQuotes(input));
                }
            };
        }
        if (format.equalsIgnoreCase("posix") || format.equalsIgnoreCase("millis") || format.equalsIgnoreCase("nano")) {
            final Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
            return new Function<String, DateTime>(){

                @Override
                public DateTime apply(String input) {
                    Preconditions.checkArgument(input != null && !input.isEmpty(), "null timestamp");
                    return (DateTime)numericFun.apply(Long.parseLong(ParserUtils.stripQuotes(input)));
                }
            };
        }
        if (format.equalsIgnoreCase("ruby")) {
            final Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
            return new Function<String, DateTime>(){

                @Override
                public DateTime apply(String input) {
                    Preconditions.checkArgument(input != null && !input.isEmpty(), "null timestamp");
                    return (DateTime)numericFun.apply(Double.parseDouble(ParserUtils.stripQuotes(input)));
                }
            };
        }
        try {
            final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return new Function<String, DateTime>(){

                @Override
                public DateTime apply(String input) {
                    Preconditions.checkArgument(input != null && !input.isEmpty(), "null timestamp");
                    return formatter.parseDateTime(ParserUtils.stripQuotes(input));
                }
            };
        }
        catch (Exception e) {
            throw new IAE(e, "Unable to parse timestamps with format [%s]", format);
        }
    }

    public static Function<Number, DateTime> createNumericTimestampParser(String format) {
        if (format.equalsIgnoreCase("posix") || format.equalsIgnoreCase("ruby")) {
            return new Function<Number, DateTime>(){

                @Override
                public DateTime apply(Number input) {
                    return new DateTime(input.longValue() * 1000L);
                }
            };
        }
        if (format.equalsIgnoreCase("nano")) {
            return new Function<Number, DateTime>(){

                @Override
                public DateTime apply(Number input) {
                    return new DateTime(input.longValue() / 1000000L);
                }
            };
        }
        return new Function<Number, DateTime>(){

            @Override
            public DateTime apply(Number input) {
                return new DateTime(input.longValue());
            }
        };
    }

    public static Function<Object, DateTime> createObjectTimestampParser(String format) {
        final Function<String, DateTime> stringFun = TimestampParser.createTimestampParser(format);
        final Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
        return new Function<Object, DateTime>(){

            @Override
            public DateTime apply(Object o) {
                Preconditions.checkArgument(o != null, "null timestamp");
                if (o instanceof Number) {
                    return (DateTime)numericFun.apply((Number)o);
                }
                return (DateTime)stringFun.apply(o.toString());
            }
        };
    }
}

