/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.java.util.common.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public class Lifecycle {
    private static final Logger log = new Logger(Lifecycle.class);
    private final Map<Stage, CopyOnWriteArrayList<Handler>> handlers;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);
    private volatile Stage currStage = null;

    public Lifecycle() {
        this.handlers = Maps.newHashMap();
        for (Stage stage : Stage.values()) {
            this.handlers.put(stage, new CopyOnWriteArrayList());
        }
    }

    public <T> T addManagedInstance(T o) {
        this.addHandler(new AnnotationBasedHandler(o));
        return o;
    }

    public <T> T addManagedInstance(T o, Stage stage) {
        this.addHandler(new AnnotationBasedHandler(o), stage);
        return o;
    }

    public <T> T addStartCloseInstance(T o) {
        this.addHandler(new StartCloseHandler(o));
        return o;
    }

    public <T> T addStartCloseInstance(T o, Stage stage) {
        this.addHandler(new StartCloseHandler(o), stage);
        return o;
    }

    public void addHandler(Handler handler) {
        this.addHandler(handler, Stage.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(Handler handler, Stage stage) {
        Map<Stage, CopyOnWriteArrayList<Handler>> map = this.handlers;
        synchronized (map) {
            if (this.started.get()) {
                throw new ISE("Cannot add a handler after the Lifecycle has started, it doesn't work that way.", new Object[0]);
            }
            this.handlers.get((Object)stage).add(handler);
        }
    }

    public <T> T addMaybeStartManagedInstance(T o) throws Exception {
        this.addMaybeStartHandler(new AnnotationBasedHandler(o));
        return o;
    }

    public <T> T addMaybeStartManagedInstance(T o, Stage stage) throws Exception {
        this.addMaybeStartHandler(new AnnotationBasedHandler(o), stage);
        return o;
    }

    public <T> T addMaybeStartStartCloseInstance(T o) throws Exception {
        this.addMaybeStartHandler(new StartCloseHandler(o));
        return o;
    }

    public <T> T addMaybeStartStartCloseInstance(T o, Stage stage) throws Exception {
        this.addMaybeStartHandler(new StartCloseHandler(o), stage);
        return o;
    }

    public void addMaybeStartHandler(Handler handler) throws Exception {
        this.addMaybeStartHandler(handler, Stage.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMaybeStartHandler(Handler handler, Stage stage) throws Exception {
        Map<Stage, CopyOnWriteArrayList<Handler>> map = this.handlers;
        synchronized (map) {
            if (this.started.get() && (this.currStage == null || stage.compareTo(this.currStage) < 1)) {
                handler.start();
            }
            this.handlers.get((Object)stage).add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Map<Stage, CopyOnWriteArrayList<Handler>> map = this.handlers;
        synchronized (map) {
            if (!this.started.compareAndSet(false, true)) {
                throw new ISE("Already started", new Object[0]);
            }
            Iterator<Stage> iterator = Lifecycle.stagesOrdered().iterator();
            while (iterator.hasNext()) {
                Stage stage;
                this.currStage = stage = iterator.next();
                for (Handler handler : this.handlers.get((Object)stage)) {
                    handler.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<Stage, CopyOnWriteArrayList<Handler>> map = this.handlers;
        synchronized (map) {
            if (!this.started.compareAndSet(true, false)) {
                log.info("Already stopped and stop was called. Silently skipping", new Object[0]);
                return;
            }
            ArrayList<Exception> exceptions = Lists.newArrayList();
            for (Stage stage : Lists.reverse(Lifecycle.stagesOrdered())) {
                CopyOnWriteArrayList<Handler> stageHandlers = this.handlers.get((Object)stage);
                ListIterator<Handler> iter = stageHandlers.listIterator(stageHandlers.size());
                while (iter.hasPrevious()) {
                    Handler handler = iter.previous();
                    try {
                        handler.stop();
                    }
                    catch (Exception e) {
                        log.warn(e, "exception thrown when stopping %s", handler);
                        exceptions.add(e);
                    }
                }
            }
            if (!exceptions.isEmpty()) {
                throw Throwables.propagate((Throwable)exceptions.get(0));
            }
        }
    }

    public void ensureShutdownHook() {
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    log.info("Running shutdown hook", new Object[0]);
                    Lifecycle.this.stop();
                }
            }));
        }
    }

    public void join() throws InterruptedException {
        this.ensureShutdownHook();
        Thread.currentThread().join();
    }

    private static List<Stage> stagesOrdered() {
        return Arrays.asList(Stage.NORMAL, Stage.LAST);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private static class StartCloseHandler
    implements Handler {
        private static final Logger log = new Logger(StartCloseHandler.class);
        private final Object o;
        private final Method startMethod;
        private final Method stopMethod;

        public StartCloseHandler(Object o) {
            this.o = o;
            try {
                this.startMethod = o.getClass().getMethod("start", new Class[0]);
                this.stopMethod = o.getClass().getMethod("close", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void start() throws Exception {
            log.info("Starting object[%s]", this.o);
            this.startMethod.invoke(this.o, new Object[0]);
        }

        @Override
        public void stop() {
            log.info("Stopping object[%s]", this.o);
            try {
                this.stopMethod.invoke(this.o, new Object[0]);
            }
            catch (Exception e) {
                log.error(e, "Unable to invoke stopMethod() on %s", this.o.getClass());
            }
        }
    }

    private static class AnnotationBasedHandler
    implements Handler {
        private static final Logger log = new Logger(AnnotationBasedHandler.class);
        private final Object o;

        public AnnotationBasedHandler(Object o) {
            this.o = o;
        }

        @Override
        public void start() throws Exception {
            for (Method method : this.o.getClass().getMethods()) {
                boolean doStart = false;
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getCanonicalName().equals("org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStart") && !annotation.annotationType().getCanonicalName().equals("org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart")) continue;
                    doStart = true;
                    break;
                }
                if (!doStart) continue;
                log.info("Invoking start method[%s] on object[%s].", method, this.o);
                method.invoke(this.o, new Object[0]);
            }
        }

        @Override
        public void stop() {
            for (Method method : this.o.getClass().getMethods()) {
                boolean doStop = false;
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getCanonicalName().equals("org.apache.hive.druid.io.druid.java.util.common.lifecycle.LifecycleStop") && !annotation.annotationType().getCanonicalName().equals("org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop")) continue;
                    doStop = true;
                    break;
                }
                if (!doStop) continue;
                log.info("Invoking stop method[%s] on object[%s].", method, this.o);
                try {
                    method.invoke(this.o, new Object[0]);
                }
                catch (Exception e) {
                    log.error(e, "Exception when stopping method[%s] on object[%s]", method, this.o);
                }
            }
        }
    }

    public static interface Handler {
        public void start() throws Exception;

        public void stop();
    }

    public static enum Stage {
        NORMAL,
        LAST;

    }
}

