/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.initialization;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.util.Modules;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.curator.CuratorModule;
import org.apache.hive.druid.io.druid.curator.discovery.DiscoveryModule;
import org.apache.hive.druid.io.druid.guice.AWSModule;
import org.apache.hive.druid.io.druid.guice.AnnouncerModule;
import org.apache.hive.druid.io.druid.guice.CoordinatorDiscoveryModule;
import org.apache.hive.druid.io.druid.guice.DruidProcessingConfigModule;
import org.apache.hive.druid.io.druid.guice.DruidSecondaryModule;
import org.apache.hive.druid.io.druid.guice.ExpressionModule;
import org.apache.hive.druid.io.druid.guice.ExtensionsConfig;
import org.apache.hive.druid.io.druid.guice.FirehoseModule;
import org.apache.hive.druid.io.druid.guice.IndexingServiceDiscoveryModule;
import org.apache.hive.druid.io.druid.guice.JacksonConfigManagerModule;
import org.apache.hive.druid.io.druid.guice.JavaScriptModule;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.guice.LocalDataStorageDruidModule;
import org.apache.hive.druid.io.druid.guice.MetadataConfigModule;
import org.apache.hive.druid.io.druid.guice.ModulesConfig;
import org.apache.hive.druid.io.druid.guice.ParsersModule;
import org.apache.hive.druid.io.druid.guice.ServerModule;
import org.apache.hive.druid.io.druid.guice.ServerViewModule;
import org.apache.hive.druid.io.druid.guice.StartupLoggingModule;
import org.apache.hive.druid.io.druid.guice.StorageNodeModule;
import org.apache.hive.druid.io.druid.guice.annotations.Client;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.guice.http.HttpClientModule;
import org.apache.hive.druid.io.druid.guice.security.DruidAuthModule;
import org.apache.hive.druid.io.druid.initialization.DruidModule;
import org.apache.hive.druid.io.druid.initialization.Log4jShutterDownerModule;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import org.apache.hive.druid.io.druid.server.initialization.EmitterModule;
import org.apache.hive.druid.io.druid.server.initialization.jetty.JettyServerModule;
import org.apache.hive.druid.io.druid.server.metrics.MetricsModule;
import org.eclipse.aether.artifact.DefaultArtifact;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final ConcurrentMap<File, URLClassLoader> loadersMap = new ConcurrentHashMap<File, URLClassLoader>();
    private static final Map<Class, Collection> extensionsMap = Maps.newHashMap();

    public static <T> Collection<T> getLoadedImplementations(Class<T> clazz) {
        Collection retVal = extensionsMap.get(clazz);
        if (retVal == null) {
            return Sets.newHashSet();
        }
        return retVal;
    }

    @VisibleForTesting
    static void clearLoadedImplementations() {
        extensionsMap.clear();
    }

    @VisibleForTesting
    static Map<File, URLClassLoader> getLoadersMap() {
        return loadersMap;
    }

    public static synchronized <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> serviceClass) {
        List modulesToLoad = new ServiceLoadingFromExtensions(config, serviceClass).implsToLoad;
        extensionsMap.put(serviceClass, modulesToLoad);
        return modulesToLoad;
    }

    public static File[] getExtensionFilesToLoad(ExtensionsConfig config) {
        File[] extensionsToLoad;
        File rootExtensionsDir = new File(config.getDirectory());
        if (rootExtensionsDir.exists() && !rootExtensionsDir.isDirectory()) {
            throw new ISE("Root extensions directory [%s] is not a directory!?", rootExtensionsDir);
        }
        List<String> toLoad = config.getLoadList();
        if (toLoad == null) {
            extensionsToLoad = rootExtensionsDir.listFiles();
        } else {
            int i = 0;
            extensionsToLoad = new File[toLoad.size()];
            for (String extensionName : toLoad) {
                File extensionDir = new File(extensionName);
                if (!extensionDir.isAbsolute()) {
                    extensionDir = new File(rootExtensionsDir, extensionName);
                }
                if (!extensionDir.isDirectory()) {
                    throw new ISE("Extension [%s] specified in \"druid.extensions.loadList\" didn't exist!?", extensionDir.getAbsolutePath());
                }
                extensionsToLoad[i++] = extensionDir;
            }
        }
        return extensionsToLoad == null ? new File[]{} : extensionsToLoad;
    }

    public static File[] getHadoopDependencyFilesToLoad(List<String> hadoopDependencyCoordinates, ExtensionsConfig extensionsConfig) {
        File rootHadoopDependenciesDir = new File(extensionsConfig.getHadoopDependenciesDir());
        if (rootHadoopDependenciesDir.exists() && !rootHadoopDependenciesDir.isDirectory()) {
            throw new ISE("Root Hadoop dependencies directory [%s] is not a directory!?", rootHadoopDependenciesDir);
        }
        File[] hadoopDependenciesToLoad = new File[hadoopDependencyCoordinates.size()];
        int i = 0;
        for (String coordinate : hadoopDependencyCoordinates) {
            DefaultArtifact artifact = new DefaultArtifact(coordinate);
            File hadoopDependencyDir = new File(rootHadoopDependenciesDir, artifact.getArtifactId());
            File versionDir = new File(hadoopDependencyDir, artifact.getVersion());
            if (!hadoopDependencyDir.isDirectory() || !versionDir.isDirectory()) {
                throw new ISE("Hadoop dependency [%s] didn't exist!?", versionDir.getAbsolutePath());
            }
            hadoopDependenciesToLoad[i++] = versionDir;
        }
        return hadoopDependenciesToLoad;
    }

    public static URLClassLoader getClassLoaderForExtension(File extension) throws MalformedURLException {
        URLClassLoader loader = (URLClassLoader)loadersMap.get(extension);
        if (loader == null) {
            Collection jars = FileUtils.listFiles((File)extension, (String[])new String[]{"jar"}, (boolean)false);
            URL[] urls = new URL[jars.size()];
            int i = 0;
            for (File jar : jars) {
                URL url = jar.toURI().toURL();
                log.info("added URL[%s]", url);
                urls[i++] = url;
            }
            loadersMap.putIfAbsent(extension, new URLClassLoader(urls, Initialization.class.getClassLoader()));
            loader = (URLClassLoader)loadersMap.get(extension);
        }
        return loader;
    }

    public static List<URL> getURLsForClasspath(String cp) {
        try {
            String[] paths = cp.split(File.pathSeparator);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i = 0; i < paths.length; ++i) {
                File f = new File(paths[i]);
                if ("*".equals(f.getName())) {
                    File[] jars;
                    File parentDir = f.getParentFile();
                    if (!parentDir.isDirectory()) continue;
                    for (File jar : jars = parentDir.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name != null && (name.endsWith(".jar") || name.endsWith(".JAR"));
                        }
                    })) {
                        urls.add(jar.toURI().toURL());
                    }
                    continue;
                }
                urls.add(new File(paths[i]).toURI().toURL());
            }
            return urls;
        }
        catch (IOException ex) {
            throw Throwables.propagate(ex);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<? extends com.google.inject.Module> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector);
        defaultModules.addModules(new Object[]{new Log4jShutterDownerModule(), new DruidAuthModule(), new LifecycleModule(), EmitterModule.class, HttpClientModule.global(), new HttpClientModule("druid.broker.http", Client.class), new CuratorModule(), new AnnouncerModule(), new AWSModule(), new MetricsModule(), new ServerModule(), new DruidProcessingConfigModule(), new StorageNodeModule(), new JettyServerModule(), new ExpressionModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new IndexingServiceDiscoveryModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new FirehoseModule(), new ParsersModule(), new JavaScriptModule(), new StartupLoggingModule()});
        ModuleList actualModules = new ModuleList(baseInjector);
        actualModules.addModule(DruidSecondaryModule.class);
        for (com.google.inject.Module module : modules) {
            actualModules.addModule(module);
        }
        com.google.inject.Module intermediateModules = Modules.override((Iterable)defaultModules.getModules()).with((Iterable)actualModules.getModules());
        ModuleList moduleList = new ModuleList(baseInjector);
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (DruidModule module : Initialization.getFromExtensions(config, DruidModule.class)) {
            moduleList.addModule(module);
        }
        return Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{Modules.override((com.google.inject.Module[])new com.google.inject.Module[]{intermediateModules}).with((Iterable)moduleList.getModules())});
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final ModulesConfig modulesConfig;
        private final ObjectMapper jsonMapper;
        private final ObjectMapper smileMapper;
        private final List<com.google.inject.Module> modules;

        public ModuleList(Injector baseInjector) {
            this.baseInjector = baseInjector;
            this.modulesConfig = (ModulesConfig)baseInjector.getInstance(ModulesConfig.class);
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
            this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
            this.modules = Lists.newArrayList();
        }

        private List<com.google.inject.Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (input instanceof DruidModule) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add(this.registerJacksonModules((DruidModule)input));
                return;
            } else if (input instanceof com.google.inject.Module) {
                if (!this.checkModuleClass(input.getClass())) {
                    return;
                }
                this.baseInjector.injectMembers(input);
                this.modules.add((com.google.inject.Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", input.getClass());
                if (!this.checkModuleClass((Class)input)) {
                    return;
                }
                if (DruidModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add(this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                    return;
                } else {
                    if (!com.google.inject.Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", input.getClass(), com.google.inject.Module.class);
                    this.modules.add((com.google.inject.Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        private boolean checkModuleClass(Class<?> moduleClass) {
            String moduleClassName = moduleClass.getCanonicalName();
            if (moduleClassName != null && this.modulesConfig.getExcludeList().contains(moduleClassName)) {
                log.info("Not loading module [%s] because it is present in excludeList", moduleClassName);
                return false;
            }
            return true;
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private DruidModule registerJacksonModules(DruidModule module) {
            for (Module module2 : module.getJacksonModules()) {
                this.jsonMapper.registerModule(module2);
                this.smileMapper.registerModule(module2);
            }
            return module;
        }
    }

    private static class ServiceLoadingFromExtensions<T> {
        private final ExtensionsConfig extensionsConfig;
        private final Class<T> serviceClass;
        private final List<T> implsToLoad = new ArrayList<T>();
        private final Set<String> implClassNamesToLoad = new HashSet<String>();

        private ServiceLoadingFromExtensions(ExtensionsConfig extensionsConfig, Class<T> serviceClass) {
            this.extensionsConfig = extensionsConfig;
            this.serviceClass = serviceClass;
            if (extensionsConfig.searchCurrentClassloader()) {
                this.addAllFromCurrentClassLoader();
            }
            this.addAllFromFileSystem();
        }

        private void addAllFromCurrentClassLoader() {
            ServiceLoader.load(this.serviceClass, Thread.currentThread().getContextClassLoader()).forEach(impl -> this.tryAdd(impl, "classpath"));
        }

        private void addAllFromFileSystem() {
            for (File extension : Initialization.getExtensionFilesToLoad(this.extensionsConfig)) {
                log.info("Loading extension [%s] for class [%s]", extension.getName(), this.serviceClass);
                try {
                    URLClassLoader loader = Initialization.getClassLoaderForExtension(extension);
                    ServiceLoader.load(this.serviceClass, loader).forEach(impl -> this.tryAdd(impl, "local file system"));
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        }

        private void tryAdd(T serviceImpl, String extensionType) {
            String serviceImplName = serviceImpl.getClass().getCanonicalName();
            if (serviceImplName == null) {
                log.warn("Implementation [%s] was ignored because it doesn't have a canonical name, is it a local or anonymous class?", serviceImpl.getClass().getName());
            } else if (!this.implClassNamesToLoad.contains(serviceImplName)) {
                log.info("Adding implementation [%s] for class [%s] from %s extension", serviceImplName, this.serviceClass, extensionType);
                this.implClassNamesToLoad.add(serviceImplName);
                this.implsToLoad.add(serviceImpl);
            }
        }
    }
}

