/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.util.Providers;
import javax.annotation.Nullable;
import org.apache.hive.druid.io.druid.client.DruidServerConfig;
import org.apache.hive.druid.io.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.NodeTypeConfig;
import org.apache.hive.druid.io.druid.guice.annotations.Self;
import org.apache.hive.druid.io.druid.query.DruidProcessingConfig;
import org.apache.hive.druid.io.druid.segment.column.ColumnConfig;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoaderConfig;
import org.apache.hive.druid.io.druid.server.DruidNode;
import org.apache.hive.druid.io.druid.server.coordination.DruidServerMetadata;

public class StorageNodeModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind(binder, "druid.server", DruidServerConfig.class);
        JsonConfigProvider.bind(binder, "druid.segmentCache", SegmentLoaderConfig.class);
        binder.bind(NodeTypeConfig.class).toProvider(Providers.of(null));
        binder.bind(ColumnConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @LazySingleton
    public DruidServerMetadata getMetadata(@Self DruidNode node, @Nullable NodeTypeConfig nodeType, DruidServerConfig config) {
        if (nodeType == null) {
            throw new ProvisionException("Must override the binding for NodeTypeConfig if you want a DruidServerMetadata.");
        }
        return new DruidServerMetadata(node.getHostAndPort(), node.getHostAndPort(), config.getMaxSize(), nodeType.getNodeType(), config.getTier(), config.getPriority());
    }
}

