/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.JSONPathFieldSpec;
import org.apache.hive.druid.io.druid.data.input.impl.JSONPathSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.java.util.common.parsers.JSONPathParser;
import org.apache.hive.druid.io.druid.java.util.common.parsers.Parser;

public class JSONParseSpec
extends ParseSpec {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final JSONPathSpec flattenSpec;
    private final Map<String, Boolean> featureSpec;

    @JsonCreator
    public JSONParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="flattenSpec") JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") Map<String, Boolean> featureSpec) {
        super(timestampSpec, dimensionsSpec);
        this.flattenSpec = flattenSpec != null ? flattenSpec : new JSONPathSpec(true, null);
        this.featureSpec = featureSpec == null ? new HashMap() : featureSpec;
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf(entry.getKey());
            this.objectMapper.configure(feature, (boolean)entry.getValue());
        }
    }

    @Deprecated
    public JSONParseSpec(TimestampSpec ts, DimensionsSpec dims) {
        this(ts, dims, null, null);
    }

    @Override
    public void verify(List<String> usedCols) {
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new JSONPathParser(this.convertFieldSpecs(this.flattenSpec.getFields()), this.flattenSpec.isUseFieldDiscovery(), this.objectMapper);
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new JSONParseSpec(spec, this.getDimensionsSpec(), this.getFlattenSpec(), this.getFeatureSpec());
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new JSONParseSpec(this.getTimestampSpec(), spec, this.getFlattenSpec(), this.getFeatureSpec());
    }

    @JsonProperty
    public JSONPathSpec getFlattenSpec() {
        return this.flattenSpec;
    }

    @JsonProperty
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    private List<JSONPathParser.FieldSpec> convertFieldSpecs(List<JSONPathFieldSpec> druidFieldSpecs) {
        ArrayList<JSONPathParser.FieldSpec> newSpecs = new ArrayList<JSONPathParser.FieldSpec>();
        for (JSONPathFieldSpec druidSpec : druidFieldSpecs) {
            JSONPathParser.FieldType type;
            switch (druidSpec.getType()) {
                case ROOT: {
                    type = JSONPathParser.FieldType.ROOT;
                    break;
                }
                case PATH: {
                    type = JSONPathParser.FieldType.PATH;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid type for field " + druidSpec.getName());
                }
            }
            JSONPathParser.FieldSpec newSpec = new JSONPathParser.FieldSpec(type, druidSpec.getName(), druidSpec.getExpr());
            newSpecs.add(newSpec);
        }
        return newSpecs;
    }
}

