/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.data.input.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.impl.FileIteratingFirehose;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public abstract class AbstractTextFilesFirehoseFactory<ObjectType>
implements FirehoseFactory<StringInputRowParser> {
    private static final Logger LOG = new Logger(AbstractTextFilesFirehoseFactory.class);
    private List<ObjectType> objects;

    @Override
    public Firehose connect(StringInputRowParser firehoseParser, File temporaryDirectory) throws IOException {
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf(Preconditions.checkNotNull(this.initObjects(), "initObjects"));
        }
        final Iterator<ObjectType> iterator = this.objects.iterator();
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public LineIterator next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = iterator.next();
                try {
                    return IOUtils.lineIterator((InputStream)AbstractTextFilesFirehoseFactory.this.wrapObjectStream(object, AbstractTextFilesFirehoseFactory.this.openObjectStream(object)), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error(e, "Exception reading object[%s]", object);
                    throw Throwables.propagate(e);
                }
            }
        }, firehoseParser);
    }

    protected abstract Collection<ObjectType> initObjects() throws IOException;

    protected abstract InputStream openObjectStream(ObjectType var1) throws IOException;

    protected abstract InputStream wrapObjectStream(ObjectType var1, InputStream var2) throws IOException;
}

