/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Strings;

public class UUIDUtils {
    public static final String UUID_DELIM = "_";

    public static String generateUuid(String ... extraData) {
        String extra = null;
        if (extraData != null && extraData.length > 0) {
            ArrayList<String> extraStrings = new ArrayList<String>(extraData.length);
            for (String extraString : extraData) {
                if (Strings.isNullOrEmpty(extraString)) continue;
                extraStrings.add(extraString);
            }
            if (!extraStrings.isEmpty()) {
                extra = Joiner.on(UUID_DELIM).join(extraStrings);
            }
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return extra == null ? uuid : extra + UUID_DELIM + uuid;
    }
}

