/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.joda.time.Period;

public class HttpServerInventoryViewConfig {
    @JsonProperty
    private final long serverTimeout;
    @JsonProperty
    private final int numThreads;

    @JsonCreator
    public HttpServerInventoryViewConfig(@JsonProperty(value="serverTimeout") Period serverTimeout, @JsonProperty(value="numThreads") Integer numThreads) {
        this.serverTimeout = serverTimeout != null ? serverTimeout.toStandardDuration().getMillis() : 240000L;
        this.numThreads = numThreads != null ? numThreads : 5;
        Preconditions.checkArgument(this.serverTimeout > 0L, "server timeout must be > 0 ms");
        Preconditions.checkArgument(this.numThreads > 1, "numThreads must be > 1");
    }

    public long getServerTimeout() {
        return this.serverTimeout;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

