/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.IOException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManager;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import org.apache.hive.druid.io.druid.curator.inventory.InventoryManagerConfig;
import org.apache.hive.druid.io.druid.java.util.common.ISE;

public class DruidServerDiscovery {
    private final EmittingLogger log = new EmittingLogger(DruidServerDiscovery.class);
    private final CuratorInventoryManager curatorInventoryManager;
    private volatile Listener listener;

    DruidServerDiscovery(CuratorFramework curatorFramework, String announcementsPath, ObjectMapper jsonMapper) {
        this.curatorInventoryManager = this.initCuratorInventoryManager(curatorFramework, announcementsPath, jsonMapper);
    }

    public void start() throws Exception {
        Preconditions.checkNotNull(this.listener, "listener is not configured yet");
        this.curatorInventoryManager.start();
    }

    public void stop() throws IOException {
        this.curatorInventoryManager.stop();
    }

    private CuratorInventoryManager initCuratorInventoryManager(CuratorFramework curator, final String announcementsPath, final ObjectMapper jsonMapper) {
        return new CuratorInventoryManager<DruidServer, Object>(curator, new InventoryManagerConfig(){

            @Override
            public String getContainerPath() {
                return announcementsPath;
            }

            @Override
            public String getInventoryPath() {
                return "/NON_EXISTENT_DUMMY_INVENTORY_PATH";
            }
        }, Execs.singleThreaded("CuratorInventoryManagerBasedServerDiscovery-%s"), new CuratorInventoryManagerStrategy<DruidServer, Object>(){

            @Override
            public DruidServer deserializeContainer(byte[] bytes) {
                try {
                    return jsonMapper.readValue(bytes, DruidServer.class);
                }
                catch (IOException e) {
                    throw Throwables.propagate(e);
                }
            }

            @Override
            public void newContainer(DruidServer container) {
                DruidServerDiscovery.this.log.info("New Server[%s]", container.getName());
                DruidServerDiscovery.this.listener.serverAdded(container);
            }

            @Override
            public void deadContainer(DruidServer container) {
                DruidServerDiscovery.this.log.info("Server Disappeared[%s]", container.getName());
                DruidServerDiscovery.this.listener.serverRemoved(container);
            }

            @Override
            public DruidServer updateContainer(DruidServer oldContainer, DruidServer newContainer) {
                DruidServerDiscovery.this.log.info("Server updated[%s]", oldContainer.getName());
                return DruidServerDiscovery.this.listener.serverUpdated(oldContainer, newContainer);
            }

            @Override
            public Object deserializeInventory(byte[] bytes) {
                throw new ISE("no inventory should exist.", new Object[0]);
            }

            @Override
            public DruidServer addInventory(DruidServer container, String inventoryKey, Object inventory) {
                throw new ISE("no inventory should exist.", new Object[0]);
            }

            @Override
            public DruidServer updateInventory(DruidServer container, String inventoryKey, Object inventory) {
                throw new ISE("no inventory should exist.", new Object[0]);
            }

            @Override
            public DruidServer removeInventory(DruidServer container, String inventoryKey) {
                throw new ISE("no inventory should exist.", new Object[0]);
            }

            @Override
            public void inventoryInitialized() {
                DruidServerDiscovery.this.log.info("Server inventory initialized.", new Object[0]);
                DruidServerDiscovery.this.listener.initialized();
            }
        });
    }

    public void registerListener(Listener listener) {
        Preconditions.checkArgument(this.listener == null, "listener registered already.");
        this.listener = listener;
    }

    public static interface Listener {
        public void serverAdded(DruidServer var1);

        public DruidServer serverUpdated(DruidServer var1, DruidServer var2);

        public void serverRemoved(DruidServer var1);

        public void initialized();
    }
}

