/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core.factory;

import java.util.HashSet;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.common.lifecycle.Lifecycle;
import org.apache.hive.druid.com.metamx.emitter.core.Emitter;
import org.apache.hive.druid.com.metamx.emitter.core.FeedUriExtractor;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriEmitter;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriEmitterConfig;
import org.apache.hive.druid.com.metamx.emitter.core.ParametrizedUriExtractor;
import org.apache.hive.druid.com.metamx.emitter.core.UriExtractor;
import org.apache.hive.druid.com.metamx.emitter.core.factory.EmitterFactory;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;

public class ParametrizedUriEmitterFactory
extends ParametrizedUriEmitterConfig
implements EmitterFactory {
    @JsonCreator
    public ParametrizedUriEmitterFactory(@NotNull @JsonProperty(value="recipientBaseUrlPattern") String recipientBaseUrlPattern) {
        super(recipientBaseUrlPattern);
    }

    @Override
    public Emitter makeEmitter(ObjectMapper objectMapper, HttpClient httpClient, Lifecycle lifecycle) {
        String baseUri = this.getRecipientBaseUrlPattern();
        ParametrizedUriExtractor parametrizedUriExtractor = new ParametrizedUriExtractor(baseUri);
        HashSet<String> onlyFeedParam = new HashSet<String>();
        onlyFeedParam.add("feed");
        UriExtractor uriExtractor = parametrizedUriExtractor;
        if (parametrizedUriExtractor.getParams().equals(onlyFeedParam)) {
            uriExtractor = new FeedUriExtractor(baseUri.replace("{feed}", "%s"));
        }
        ParametrizedUriEmitter retVal = new ParametrizedUriEmitter(this, httpClient, objectMapper, uriExtractor);
        lifecycle.addManagedInstance(retVal);
        return retVal;
    }
}

