/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.core;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.metamx.emitter.core.BatchingStrategy;
import org.apache.hive.druid.com.metamx.emitter.core.ContentEncoding;

public class HttpEmitterConfig {
    private static final long DEFAULT_FLUSH_MILLIS = 60000L;
    private static final int DEFAULT_FLUSH_COUNTS = 500;
    private static final String DEFAULT_RECIPIENT_BASE_URL = null;
    private static final int DEFAULT_MAX_BATCH_SIZE = 0x500000;
    private static final long DEFAULT_MAX_BUFFER_SIZE = 0xFA00000L;
    private static final long DEFAULT_FLUSH_TIME_OUT = Long.MAX_VALUE;
    private static final String DEFAULT_BASIC_AUTHENTICATION = null;
    private static final BatchingStrategy DEFAULT_BATCHING_STRATEGY = BatchingStrategy.ARRAY;
    private static final ContentEncoding DEFAULT_CONTENT_ENCODING = null;
    @Min(value=1L)
    @JsonProperty
    private long flushMillis = 60000L;
    @Min(value=0L)
    @JsonProperty
    private int flushCount = 500;
    @Min(value=0L)
    @JsonProperty
    private long flushTimeOut = Long.MAX_VALUE;
    @NotNull
    @JsonProperty
    private String recipientBaseUrl = DEFAULT_RECIPIENT_BASE_URL;
    @JsonProperty
    private String basicAuthentication = DEFAULT_BASIC_AUTHENTICATION;
    @JsonProperty
    private BatchingStrategy batchingStrategy = DEFAULT_BATCHING_STRATEGY;
    @Min(value=0L)
    @JsonProperty
    private int maxBatchSize = 0x500000;
    @Min(value=0L)
    @JsonProperty
    private long maxBufferSize = 0xFA00000L;
    @JsonProperty
    private ContentEncoding contentEncoding = DEFAULT_CONTENT_ENCODING;

    public HttpEmitterConfig() {
    }

    @Deprecated
    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, DEFAULT_BASIC_AUTHENTICATION, DEFAULT_BATCHING_STRATEGY, 0x500000, 0xFA00000L);
    }

    @Deprecated
    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl, int maxBatchSize, long maxBufferSize) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, DEFAULT_BASIC_AUTHENTICATION, DEFAULT_BATCHING_STRATEGY, maxBatchSize, maxBufferSize);
    }

    @Deprecated
    public HttpEmitterConfig(long flushMillis, int flushCount, String recipientBaseUrl, String basicAuthentication, BatchingStrategy batchingStrategy, int maxBatchSize, long maxBufferSize) {
        this(flushMillis, flushCount, Long.MAX_VALUE, recipientBaseUrl, basicAuthentication, batchingStrategy, maxBatchSize, maxBufferSize);
    }

    @Deprecated
    public HttpEmitterConfig(long flushMillis, int flushCount, long flushTimeOut, String recipientBaseUrl, String basicAuthentication, BatchingStrategy batchingStrategy, int maxBatchSize, long maxBufferSize) {
        this(flushMillis, flushCount, flushTimeOut, recipientBaseUrl, basicAuthentication, batchingStrategy, maxBatchSize, maxBufferSize, DEFAULT_CONTENT_ENCODING);
    }

    private HttpEmitterConfig(long flushMillis, int flushCount, long flushTimeOut, String recipientBaseUrl, String basicAuthentication, BatchingStrategy batchingStrategy, int maxBatchSize, long maxBufferSize, ContentEncoding contentEncoding) {
        this.flushMillis = flushMillis;
        this.flushCount = flushCount;
        this.flushTimeOut = flushTimeOut;
        this.recipientBaseUrl = recipientBaseUrl;
        this.basicAuthentication = basicAuthentication;
        this.batchingStrategy = batchingStrategy;
        this.maxBatchSize = maxBatchSize;
        this.maxBufferSize = maxBufferSize;
        this.contentEncoding = contentEncoding;
    }

    public long getFlushMillis() {
        return this.flushMillis;
    }

    public int getFlushCount() {
        return this.flushCount;
    }

    public long getFlushTimeOut() {
        return this.flushTimeOut;
    }

    public String getRecipientBaseUrl() {
        return this.recipientBaseUrl;
    }

    public String getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public BatchingStrategy getBatchingStrategy() {
        return this.batchingStrategy;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public ContentEncoding getContentEncoding() {
        return this.contentEncoding;
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_RECIPIENT_BASE_URL;
    }

    static /* synthetic */ String access$100() {
        return DEFAULT_BASIC_AUTHENTICATION;
    }

    static /* synthetic */ BatchingStrategy access$200() {
        return DEFAULT_BATCHING_STRATEGY;
    }

    static /* synthetic */ ContentEncoding access$300() {
        return DEFAULT_CONTENT_ENCODING;
    }

    public static class Builder {
        private long flushMillis = 60000L;
        private int flushCount = 500;
        private String recipientBaseUrl = HttpEmitterConfig.access$000();
        private long flushTimeOut = Long.MAX_VALUE;
        private String basicAuthentication = HttpEmitterConfig.access$100();
        private BatchingStrategy batchingStrategy = HttpEmitterConfig.access$200();
        private int maxBatchSize = 0x500000;
        private long maxBufferSize = 0xFA00000L;
        private ContentEncoding contentEncoding = HttpEmitterConfig.access$300();

        public Builder(String recipientBaseUrl) {
            this.recipientBaseUrl = recipientBaseUrl;
        }

        public Builder copyWithRecipientBaseUrl(String recipientBaseUrl) {
            Builder b = new Builder(recipientBaseUrl);
            b.setBasicAuthentication(this.basicAuthentication).setBatchingStrategy(this.batchingStrategy).setContentEncoding(this.contentEncoding).setFlushCount(this.flushCount).setFlushMillis(this.flushMillis).setFlushTimeOut(this.flushTimeOut).setMaxBatchSize(this.maxBatchSize).setMaxBufferSize(this.maxBufferSize);
            return b;
        }

        public Builder setFlushMillis(long flushMillis) {
            this.flushMillis = flushMillis;
            return this;
        }

        public Builder setFlushCount(int flushCount) {
            this.flushCount = flushCount;
            return this;
        }

        public Builder setFlushTimeOut(long flushTimeOut) {
            this.flushTimeOut = flushTimeOut;
            return this;
        }

        public Builder setBasicAuthentication(String basicAuthentication) {
            this.basicAuthentication = basicAuthentication;
            return this;
        }

        public Builder setBatchingStrategy(BatchingStrategy batchingStrategy) {
            this.batchingStrategy = batchingStrategy;
            return this;
        }

        public Builder setMaxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder setMaxBufferSize(long maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder setContentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public HttpEmitterConfig build() {
            return new HttpEmitterConfig(this.flushMillis, this.flushCount, this.flushTimeOut, this.recipientBaseUrl, this.basicAuthentication, this.batchingStrategy, this.maxBatchSize, this.maxBufferSize, this.contentEncoding);
        }
    }
}

