/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.io.IOException;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.metamx.common.guava.Accumulator;
import org.apache.hive.druid.com.metamx.common.guava.FilteringAccumulator;
import org.apache.hive.druid.com.metamx.common.guava.FilteringYieldingAccumulator;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Yielder;
import org.apache.hive.druid.com.metamx.common.guava.YieldingAccumulator;

public class FilteredSequence<T>
implements Sequence<T> {
    private final Sequence<T> baseSequence;
    private final Predicate<T> pred;

    public FilteredSequence(Sequence<T> baseSequence, Predicate<T> pred) {
        this.baseSequence = baseSequence;
        this.pred = pred;
    }

    @Override
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        return this.baseSequence.accumulate(initValue, new FilteringAccumulator<OutType, T>(this.pred, accumulator));
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        FilteringYieldingAccumulator<OutType, T> filteringAccumulator = new FilteringYieldingAccumulator<OutType, T>(this.pred, accumulator);
        return this.wrapYielder(this.baseSequence.toYielder(initValue, filteringAccumulator), filteringAccumulator);
    }

    private <OutType> Yielder<OutType> wrapYielder(final Yielder<OutType> yielder, final FilteringYieldingAccumulator<OutType, T> accumulator) {
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yielder.get();
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                return FilteredSequence.this.wrapYielder(yielder.next(initValue), accumulator);
            }

            @Override
            public boolean isDone() {
                return !accumulator.didSomething() || yielder.isDone();
            }

            @Override
            public void close() throws IOException {
                yielder.close();
            }
        };
    }
}

