/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.io.IOException;
import java.net.CookieManager;
import java.net.URI;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseCookieHandler<Intermediate, Final>
implements HttpResponseHandler<Intermediate, Final> {
    protected static final Logger log = LoggerFactory.getLogger(ResponseCookieHandler.class);
    private final URI uri;
    private final CookieManager manager;
    private final HttpResponseHandler<Intermediate, Final> delegate;

    public ResponseCookieHandler(URI uri, CookieManager manager, HttpResponseHandler<Intermediate, Final> delegate) {
        this.uri = uri;
        this.manager = manager;
        this.delegate = delegate;
    }

    @Override
    public ClientResponse<Intermediate> handleResponse(HttpResponse httpResponse) {
        try {
            final HttpHeaders headers = httpResponse.headers();
            this.manager.put(this.uri, Maps.asMap(headers.names(), new Function<String, List<String>>(){

                @Override
                public List<String> apply(String input) {
                    return headers.getAll(input);
                }
            }));
        }
        catch (IOException e) {
            log.error("Error while processing Cookies from header", (Throwable)e);
        }
        finally {
            return this.delegate.handleResponse(httpResponse);
        }
    }

    @Override
    public ClientResponse<Intermediate> handleChunk(ClientResponse<Intermediate> clientResponse, HttpChunk httpChunk) {
        return this.delegate.handleChunk(clientResponse, httpChunk);
    }

    @Override
    public ClientResponse<Final> done(ClientResponse<Intermediate> clientResponse) {
        return this.delegate.done(clientResponse);
    }

    @Override
    public void exceptionCaught(ClientResponse<Intermediate> clientResponse, Throwable throwable) {
        this.delegate.exceptionCaught(clientResponse, throwable);
    }
}

