/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.security;

import java.net.CookieManager;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.hadoop.hive.druid.security.DruidKerberosUtil;
import org.apache.hadoop.hive.druid.security.ResponseCookieHandler;
import org.apache.hadoop.hive.druid.security.RetryIfUnauthorizedResponseHandler;
import org.apache.hadoop.hive.druid.security.RetryResponseHolder;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.com.metamx.http.client.AbstractHttpClient;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosHttpClient
extends AbstractHttpClient {
    protected static final Logger log = LoggerFactory.getLogger(KerberosHttpClient.class);
    private final HttpClient delegate;
    private final CookieManager cookieManager;
    private final Executor exec = Execs.singleThreaded("KerberosHttpClient-%s");

    public KerberosHttpClient(HttpClient delegate) {
        this.delegate = delegate;
        this.cookieManager = new CookieManager();
    }

    @Override
    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
        SettableFuture retVal = SettableFuture.create();
        this.inner_go(request, httpResponseHandler, duration, retVal);
        return retVal;
    }

    private <Intermediate, Final> void inner_go(final Request request, final HttpResponseHandler<Intermediate, Final> httpResponseHandler, final Duration duration, final SettableFuture<Final> future) {
        try {
            boolean should_retry_on_unauthorized_response;
            final String host = request.getUrl().getHost();
            final URI uri = request.getUrl().toURI();
            Map<String, List<String>> cookieMap = this.cookieManager.get(uri, Collections.emptyMap());
            for (Map.Entry<String, List<String>> entry : cookieMap.entrySet()) {
                request.addHeaderValues(entry.getKey(), (Iterable<String>)entry.getValue());
            }
            if (DruidKerberosUtil.needToSendCredentials(this.cookieManager.getCookieStore(), uri)) {
                log.info("No Auth Cookie found for URI{}. Existing Cookies{} Authenticating... ", (Object)uri, this.cookieManager.getCookieStore().getCookies());
                UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
                log.debug("The user credential is {}", (Object)currentUser);
                String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                    @Override
                    public String run() throws Exception {
                        return DruidKerberosUtil.kerberosChallenge(host);
                    }
                });
                request.setHeader("Authorization", "Negotiate " + challenge);
                should_retry_on_unauthorized_response = false;
            } else {
                should_retry_on_unauthorized_response = true;
            }
            ListenableFuture<Final> internalFuture = this.delegate.go(request, new RetryIfUnauthorizedResponseHandler<Intermediate, Final>(new ResponseCookieHandler<Intermediate, Final>(request.getUrl().toURI(), this.cookieManager, httpResponseHandler)), duration);
            Futures.addCallback(internalFuture, new FutureCallback<RetryResponseHolder<Final>>(){

                @Override
                public void onSuccess(RetryResponseHolder<Final> result) {
                    if (should_retry_on_unauthorized_response && result.shouldRetry()) {
                        log.info("Preparing for Retry");
                        DruidKerberosUtil.removeAuthCookie(KerberosHttpClient.this.cookieManager.getCookieStore(), uri);
                        request.setHeader("Cookie", "");
                        KerberosHttpClient.this.inner_go(request.copy(), httpResponseHandler, duration, future);
                    } else {
                        log.debug("Not retrying and returning future response");
                        future.set(result.getObj());
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    future.setException(t);
                }
            }, this.exec);
        }
        catch (Throwable e) {
            throw Throwables.propagate(e);
        }
    }
}

