/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class FileUtils {
    public static void copyDirectory(Path source, Path target) throws IOException {
        Objects.requireNonNull(source);
        Objects.requireNonNull(target);
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source must be a directory");
        }
        if (!Files.isDirectory(target, new LinkOption[0])) {
            throw new IllegalArgumentException("Target must be a directory");
        }
        Files.walkFileTree(source, new DirectoryCopier(source, target));
    }

    private static class DirectoryCopier
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;

        public DirectoryCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path targetFile = this.target.resolve(this.source.relativize(file));
            Path targetDir = targetFile.getParent();
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            CopyOption[] copyOptions = Files.exists(targetFile, new LinkOption[0]) ? new CopyOption[]{StandardCopyOption.REPLACE_EXISTING} : new CopyOption[]{};
            Files.copy(file, targetFile, copyOptions);
            return FileVisitResult.CONTINUE;
        }
    }
}

