/*
 * Decompiled with CFR 0.152.
 */
package jline.console.completer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CompletionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CandidateListCompletionHandler
implements CompletionHandler {
    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            CharSequence value2 = candidates.get(0);
            if (value2.equals(buf.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(reader, value2, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value3 = this.getUnambiguousCompletions(candidates);
            CandidateListCompletionHandler.setBuffer(reader, value3, pos);
        }
        CandidateListCompletionHandler.printCandidates(reader, candidates);
        reader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader reader, CharSequence value2, int offset) throws IOException {
        while (reader.getCursorBuffer().cursor > offset && reader.backspace()) {
        }
        reader.putString(value2);
        reader.setCursorPosition(offset + value2.length());
    }

    public static void printCandidates(ConsoleReader reader, Collection<CharSequence> candidates) throws IOException {
        HashSet<CharSequence> distinct = new HashSet<CharSequence>(candidates);
        if (distinct.size() > reader.getAutoprintThreshold()) {
            int c;
            reader.print(Messages.DISPLAY_CANDIDATES.format(candidates.size()));
            reader.flush();
            String noOpt = Messages.DISPLAY_CANDIDATES_NO.format(new Object[0]);
            String yesOpt = Messages.DISPLAY_CANDIDATES_YES.format(new Object[0]);
            char[] allowed = new char[]{yesOpt.charAt(0), noOpt.charAt(0)};
            while ((c = reader.readCharacter(allowed)) != -1) {
                String tmp = new String(new char[]{(char)c});
                if (noOpt.startsWith(tmp)) {
                    reader.println();
                    return;
                }
                if (yesOpt.startsWith(tmp)) break;
                reader.beep();
            }
        }
        if (distinct.size() != candidates.size()) {
            ArrayList<CharSequence> copy2 = new ArrayList<CharSequence>();
            for (CharSequence next2 : candidates) {
                if (copy2.contains(next2)) continue;
                copy2.add(next2);
            }
            candidates = copy2;
        }
        reader.println();
        reader.printColumns(candidates);
    }

    private String getUnambiguousCompletions(List<CharSequence> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        for (int i = 0; i < first.length() && this.startsWith(first.substring(0, i + 1), strings); ++i) {
            candidate.append(first.charAt(i));
        }
        return candidate.toString();
    }

    private boolean startsWith(String starts, String[] candidates) {
        for (String candidate : candidates) {
            if (candidate.startsWith(starts)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Messages {
        DISPLAY_CANDIDATES,
        DISPLAY_CANDIDATES_YES,
        DISPLAY_CANDIDATES_NO;

        private static final ResourceBundle bundle;

        public String format(Object ... args) {
            if (bundle == null) {
                return "";
            }
            return String.format(bundle.getString(this.name()), args);
        }

        static {
            bundle = ResourceBundle.getBundle(CandidateListCompletionHandler.class.getName(), Locale.getDefault());
        }
    }
}

