/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.ConstructedType;
import ch.epfl.lamp.compiler.msil.CustomModifier;
import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.PECustomMod;
import ch.epfl.lamp.compiler.msil.util.PESection;
import ch.epfl.lamp.compiler.msil.util.PEStream;
import ch.epfl.lamp.compiler.msil.util.Signature;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.LinkedList;

public class PEFile {
    public static final int INT_SIZE = 4;
    protected final int PE_SIGNATURE_OFFSET;
    protected final int COFF_HEADER_OFFSET;
    protected final int PE_HEADER_OFFSET;
    protected final int numOfSections;
    protected final int CLI_RVA;
    protected final int CLI_Length;
    public final int rvaMetadata;
    public final int posMetadata;
    protected final int numOfStreams;
    protected final int optHeaderSize;
    protected final File underlyingFile;
    protected final RandomAccessFile file;
    protected final MappedByteBuffer buf;
    protected final PESection[] sections;
    public PEStream Meta;
    public PEStream Strings;
    public PEStream US;
    public PEStream Blob;
    public PEStream GUID;
    private final Table[] tables = new Table[64];
    public final boolean isDLL;
    protected final int heapSizes;
    public final boolean StringIsShort;
    public final boolean BlobIsShort;
    public final boolean GUIDIsShort;
    protected PEModule pemodule = null;
    public final int[] indexSize = new int[13];
    public Table.ModuleDef ModuleDef;
    public Table.TypeRef TypeRef;
    public Table.TypeDef TypeDef;
    public Table.FieldTrans FieldTrans;
    public Table.FieldDef FieldDef;
    public Table.MethodTrans MethodTrans;
    public Table.MethodDef MethodDef;
    public Table.ParamDef ParamDef;
    public Table.GenericParam GenericParam;
    public Table.MethodSpec MethodSpec;
    public Table.GenericParamConstraint GenericParamConstraint;
    public Table.InterfaceImpl InterfaceImpl;
    public Table.MemberRef MemberRef;
    public Table.Constant Constant;
    public Table.CustomAttribute CustomAttribute;
    public Table.FieldMarshal FieldMarshal;
    public Table.DeclSecurity DeclSecurity;
    public Table.ClassLayout ClassLayout;
    public Table.FieldLayout FieldLayout;
    public Table.StandAloneSig StandAloneSig;
    public Table.EventMap EventMap;
    public Table.EventDef EventDef;
    public Table.PropertyMap PropertyMap;
    public Table.PropertyDef PropertyDef;
    public Table.MethodSemantics MethodSemantics;
    public Table.MethodImpl MethodImpl;
    public Table.ModuleRef ModuleRef;
    public Table.TypeSpec TypeSpec;
    public Table.ImplMap ImplMap;
    public Table.FieldRVA FieldRVA;
    public Table.AssemblyDef AssemblyDef;
    public Table.AssemblyRef AssemblyRef;
    public Table.FileDef FileDef;
    public Table.ExportedType ExportedType;
    public Table.ManifestResource ManifestResource;
    public Table.NestedClass NestedClass;

    private static void fileFormatCheck(boolean cond, String s2) {
        if (cond) {
            throw new RuntimeException(s2);
        }
    }

    public PEFile(String filename) throws FileNotFoundException {
        this.underlyingFile = new File(filename);
        this.file = new RandomAccessFile(this.underlyingFile, "r");
        FileChannel fc = this.file.getChannel();
        MappedByteBuffer bb = null;
        try {
            bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        bb.order(ByteOrder.LITTLE_ENDIAN);
        this.buf = bb;
        this.seek(0);
        PEFile.fileFormatCheck(this.readByte() != 77, "Invalid PE file format: " + filename);
        PEFile.fileFormatCheck(this.readByte() != 90, "Invalid PE file format: " + filename);
        this.seek(60);
        this.PE_SIGNATURE_OFFSET = this.readInt();
        this.seek(this.PE_SIGNATURE_OFFSET);
        PEFile.fileFormatCheck(this.readByte() != 80, "Invalid PE file format: " + filename);
        PEFile.fileFormatCheck(this.readByte() != 69, "Invalid PE file format: " + filename);
        PEFile.fileFormatCheck(this.readByte() != 0, "Invalid PE file format: " + filename);
        PEFile.fileFormatCheck(this.readByte() != 0, "Invalid PE file format: " + filename);
        this.COFF_HEADER_OFFSET = this.PE_SIGNATURE_OFFSET + 4;
        this.PE_HEADER_OFFSET = this.COFF_HEADER_OFFSET + 20;
        this.seek(this.COFF_HEADER_OFFSET);
        this.skip(2);
        this.numOfSections = this.readShort();
        Date timeStamp = new Date((long)this.readInt() * 1000L);
        this.skip(8);
        this.optHeaderSize = this.readShort();
        int characteristics = this.readShort();
        this.isDLL = (characteristics & 0x2000) != 0;
        this.seek(this.PE_HEADER_OFFSET + 208);
        this.CLI_RVA = this.readInt();
        this.CLI_Length = this.readInt();
        this.sections = new PESection[this.numOfSections];
        this.seek(this.PE_HEADER_OFFSET + this.optHeaderSize);
        for (int i = 0; i < this.numOfSections; ++i) {
            this.seek(this.PE_HEADER_OFFSET + this.optHeaderSize + i * 40);
            this.sections[i] = new PESection(this);
        }
        this.seek(this.fromRVA(this.CLI_RVA));
        this.skip(8);
        this.rvaMetadata = this.readInt();
        this.posMetadata = this.fromRVA(this.rvaMetadata);
        this.seek(this.posMetadata);
        int magic = this.readInt();
        PEFile.fileFormatCheck(magic != 1112167234, "Invalid metadata signature!");
        this.skip(8);
        int strlength = this.readInt();
        this.skip(strlength);
        this.align(4, this.posMetadata);
        this.skip(2);
        this.numOfStreams = this.readShort();
        for (int i = 0; i < this.numOfStreams; ++i) {
            PEStream strm = new PEStream(this);
            if (strm.name.equals("#~") || strm.name.equals("#-")) {
                this.Meta = strm;
            }
            if (strm.name.equals("#Strings")) {
                this.Strings = strm;
            }
            if (strm.name.equals("#US")) {
                this.US = strm;
            }
            if (strm.name.equals("#Blob")) {
                this.Blob = strm;
            }
            if (!strm.name.equals("#GUID")) continue;
            this.GUID = strm;
        }
        this.seek(this.Meta.offset);
        this.skip(6);
        this.heapSizes = this.readByte();
        this.StringIsShort = (this.heapSizes & 1) == 0;
        this.GUIDIsShort = (this.heapSizes & 2) == 0;
        this.BlobIsShort = (this.heapSizes & 4) == 0;
        this.skip(1);
        long tablesMask = this.readLong();
        long nonStandardTables = tablesMask & 0xFFFFFC00C04800A8L;
        this.skip(8);
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = Table.newTable(this, i, (tablesMask >> i & 1L) != 0L ? this.readInt() : 0);
        }
        this.initIndexSize();
        this.initTableRefs();
        long start = this.pos();
        for (int i = 0; i < this.tables.length; ++i) {
            start = this.tables[i].init(start);
        }
    }

    private void initIndexSize() {
        block0: for (int i = 0; i < 13; ++i) {
            this.indexSize[i] = 2;
            int[] tableSet = Table.TableSet[i];
            int treshold = 65536 >> Table.NoBits[i];
            for (int j = 0; j < tableSet.length; ++j) {
                if (tableSet[j] < 0) continue;
                Table t = this.tables[tableSet[j]];
                if (t.rows < treshold) continue;
                this.indexSize[i] = 4;
                continue block0;
            }
        }
    }

    protected void initModule(PEModule module2) {
        if (this.pemodule != null) {
            throw new RuntimeException("File " + this + " has already been assigned module " + this.pemodule + "; new module is " + module2);
        }
        this.pemodule = module2;
    }

    public Table.ModuleDef ModuleDef(int i) {
        this.ModuleDef.readRow(i);
        return this.ModuleDef;
    }

    public Table.TypeDef TypeDef(int i) {
        this.TypeDef.readRow(i);
        return this.TypeDef;
    }

    public Table.FieldTrans FieldTrans(int i) {
        this.FieldTrans.readRow(i);
        return this.FieldTrans;
    }

    public Table.FieldDef FieldDef(int i) {
        this.FieldDef.readRow(i);
        return this.FieldDef;
    }

    public Table.MethodTrans MethodTrans(int i) {
        this.MethodTrans.readRow(i);
        return this.MethodTrans;
    }

    public Table.MethodDef MethodDef(int i) {
        this.MethodDef.readRow(i);
        return this.MethodDef;
    }

    public Table.ParamDef ParamDef(int i) {
        this.ParamDef.readRow(i);
        return this.ParamDef;
    }

    public Table.GenericParam GenericParam(int i) {
        this.GenericParam.readRow(i);
        return this.GenericParam;
    }

    public Table.MethodSpec MethodSpec(int i) {
        this.MethodSpec.readRow(i);
        return this.MethodSpec;
    }

    public Table.GenericParamConstraint GenericParamConstraint(int i) {
        this.GenericParamConstraint.readRow(i);
        return this.GenericParamConstraint;
    }

    private void initTableRefs() {
        this.ModuleDef = (Table.ModuleDef)this.getTable(0);
        this.TypeRef = (Table.TypeRef)this.getTable(1);
        this.TypeDef = (Table.TypeDef)this.getTable(2);
        this.FieldTrans = (Table.FieldTrans)this.getTable(3);
        this.FieldDef = (Table.FieldDef)this.getTable(4);
        this.MethodTrans = (Table.MethodTrans)this.getTable(5);
        this.MethodDef = (Table.MethodDef)this.getTable(6);
        this.ParamDef = (Table.ParamDef)this.getTable(8);
        this.InterfaceImpl = (Table.InterfaceImpl)this.getTable(9);
        this.MemberRef = (Table.MemberRef)this.getTable(10);
        this.Constant = (Table.Constant)this.getTable(11);
        this.CustomAttribute = (Table.CustomAttribute)this.getTable(12);
        this.FieldMarshal = (Table.FieldMarshal)this.getTable(13);
        this.DeclSecurity = (Table.DeclSecurity)this.getTable(14);
        this.ClassLayout = (Table.ClassLayout)this.getTable(15);
        this.FieldLayout = (Table.FieldLayout)this.getTable(16);
        this.StandAloneSig = (Table.StandAloneSig)this.getTable(17);
        this.EventMap = (Table.EventMap)this.getTable(18);
        this.EventDef = (Table.EventDef)this.getTable(20);
        this.PropertyMap = (Table.PropertyMap)this.getTable(21);
        this.PropertyDef = (Table.PropertyDef)this.getTable(23);
        this.MethodSemantics = (Table.MethodSemantics)this.getTable(24);
        this.MethodImpl = (Table.MethodImpl)this.getTable(25);
        this.ModuleRef = (Table.ModuleRef)this.getTable(26);
        this.TypeSpec = (Table.TypeSpec)this.getTable(27);
        this.ImplMap = (Table.ImplMap)this.getTable(28);
        this.FieldRVA = (Table.FieldRVA)this.getTable(29);
        this.AssemblyDef = (Table.AssemblyDef)this.getTable(32);
        this.AssemblyRef = (Table.AssemblyRef)this.getTable(35);
        this.FileDef = (Table.FileDef)this.getTable(38);
        this.ExportedType = (Table.ExportedType)this.getTable(39);
        this.NestedClass = (Table.NestedClass)this.getTable(41);
        this.ManifestResource = (Table.ManifestResource)this.getTable(40);
        this.GenericParam = (Table.GenericParam)this.getTable(42);
        this.MethodSpec = (Table.MethodSpec)this.getTable(43);
        this.GenericParamConstraint = (Table.GenericParamConstraint)this.getTable(44);
    }

    public static String long2hex(long a) {
        StringBuffer str = new StringBuffer("0000000000000000");
        str.append(Long.toHexString(a));
        int l = str.length();
        return str.substring(l - 16, l);
    }

    public static String int2hex(int a) {
        StringBuffer str = new StringBuffer("00000000");
        str.append(Integer.toHexString(a));
        int l = str.length();
        return str.substring(l - 8, l);
    }

    public static String short2hex(int a) {
        StringBuffer str = new StringBuffer("0000");
        str.append(Integer.toHexString(a));
        int l = str.length();
        return str.substring(l - 4, l);
    }

    public static String byte2hex(int a) {
        StringBuffer str = new StringBuffer("00");
        str.append(Integer.toHexString(a));
        int l = str.length();
        return str.substring(l - 2, l);
    }

    public static String bytes2hex(byte[] buf) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            str.append(PEFile.byte2hex(buf[i]));
            if (i >= buf.length - 1) continue;
            str.append(" ");
        }
        return str.toString();
    }

    public File getUnderlyingFile() {
        return this.underlyingFile;
    }

    public String getAbsolutePath() {
        return this.underlyingFile.getAbsolutePath();
    }

    public String getName() {
        return this.underlyingFile.getName();
    }

    public String getParent() {
        return this.underlyingFile.getParent();
    }

    public File getParentFile() {
        return this.underlyingFile.getParentFile();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    public int pos() {
        return this.buf.position();
    }

    public void seek(int pos) {
        this.buf.position(pos);
    }

    public void align(int base) {
        this.align(base, 0);
    }

    public void align(int base, int offset) {
        int p = this.pos() - offset;
        this.seek(offset + (p % base == 0 ? p : (p / base + 1) * base));
    }

    public int fromRVA(int rva) {
        for (int i = 0; i < this.numOfSections; ++i) {
            if (this.sections[i].virtAddr > rva || rva > this.sections[i].virtAddr + this.sections[i].virtSize) continue;
            return rva - this.sections[i].virtAddr + this.sections[i].realAddr;
        }
        throw new RuntimeException("RVA 0x" + Integer.toHexString(rva) + " is not within this file's sections!");
    }

    public void gotoRVA(int rva) {
        this.seek(this.fromRVA(rva));
    }

    public void skip(int n) {
        this.buf.position(this.buf.position() + n);
    }

    public MappedByteBuffer mapBuffer(long offset, int size2) {
        try {
            MappedByteBuffer b = this.file.getChannel().map(FileChannel.MapMode.READ_ONLY, offset, size2);
            b.order(ByteOrder.LITTLE_ENDIAN);
            return b;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteBuffer getBuffer(long offset, int size2) {
        this.buf.mark();
        this.buf.position((int)offset);
        ByteBuffer bb = this.buf.slice();
        this.buf.reset();
        bb.limit(size2);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    public void read(byte[] bs) {
        this.buf.get(bs);
    }

    public int readByte() {
        return this.buf.get();
    }

    public int readShort() {
        return this.buf.getShort();
    }

    public int readInt() {
        return this.buf.getInt();
    }

    public long readLong() {
        return this.buf.getLong();
    }

    public int getStringIndexSize() {
        return this.StringIsShort ? 2 : 4;
    }

    public int getGUIDIndexSize() {
        return this.GUIDIsShort ? 2 : 4;
    }

    public int getBlobIndexSize() {
        return this.BlobIsShort ? 2 : 4;
    }

    public int getTableIndexSize(int tableID) {
        return this.tables[tableID].isShort ? 2 : 4;
    }

    public int getTableSetIndexSize(int tableSetID) {
        return this.indexSize[tableSetID];
    }

    public int readStringIndex() {
        return this.StringIsShort ? this.readShort() : this.readInt();
    }

    public int readGUIDIndex() {
        return this.GUIDIsShort ? this.readShort() : this.readInt();
    }

    public int readBlobIndex() {
        return this.BlobIsShort ? this.readShort() : this.readInt();
    }

    public int readTableIndex(int tableId) {
        return this.tables[tableId].isShort ? this.readShort() : this.readInt();
    }

    public int readTableSetIndex(int tableSetId) {
        return this.indexSize[tableSetId] == 2 ? this.readShort() : this.readInt();
    }

    public String getString(int pos) {
        String s2 = this.Strings.getString(pos);
        return s2;
    }

    public String getUString(int pos) {
        return this.US.getString(pos);
    }

    public byte[] getBlob(int pos) {
        return this.Blob.getBlob(pos);
    }

    public Sig getSignature(int pos) {
        return this.Blob.getSignature(pos);
    }

    public byte[] getGUID(int pos) {
        return this.GUID.getGUID(pos);
    }

    public final Table getTable(int tableID) {
        return this.tables[tableID];
    }

    void trace(String msg) {
        System.out.println("[trace] " + msg);
    }

    public Sig newSignature(ByteBuffer buf) {
        return new Sig(buf);
    }

    public class Sig
    implements Signature {
        protected final ByteBuffer buf;
        protected final int pos;
        protected final int length;

        public Sig(ByteBuffer buf) {
            this.buf = buf;
            this.length = this.decodeInt();
            this.pos = buf.position();
        }

        public String toString() {
            StringBuffer b = new StringBuffer("(");
            int savedPos = this.buf.position();
            this.reset();
            for (int i = 0; i < this.length; ++i) {
                b.append(PEFile.byte2hex(this.readByte()));
                if (i >= this.length - 1) continue;
                b.append(" ");
            }
            this.buf.position(savedPos);
            return b.append(")").toString();
        }

        public Sig reset() {
            this.buf.position(this.pos);
            return this;
        }

        public int pos() {
            return this.buf.position() - this.pos;
        }

        public int getByte() {
            return this.buf.get(this.buf.position()) + 256 & 0xFF;
        }

        public int readByte() {
            return this.buf.get() + 256 & 0xFF;
        }

        public void skipByte(int b) {
            if (b == this.getByte()) {
                this.buf.get();
            }
        }

        public int decodeInt() {
            int res = this.readByte();
            if ((res & 0x80) != 0 && ((res = (res & 0x7F) << 8 | this.readByte()) & 0x4000) != 0) {
                res = (res & 0x3FFF) << 16 | this.readByte() << 8 | this.readByte();
            }
            return res;
        }

        public Type decodeType() {
            try {
                return this.decodeType0();
            }
            catch (RuntimeException e) {
                System.out.println("" + this.pos() + "@" + this);
                throw e;
            }
        }

        public Type decodeType0() {
            Type type = null;
            int desc = this.readByte();
            switch (desc) {
                case 2: {
                    type = Type.GetType("System.Boolean");
                    break;
                }
                case 3: {
                    type = Type.GetType("System.Char");
                    break;
                }
                case 4: {
                    type = Type.GetType("System.SByte");
                    break;
                }
                case 5: {
                    type = Type.GetType("System.Byte");
                    break;
                }
                case 6: {
                    type = Type.GetType("System.Int16");
                    break;
                }
                case 7: {
                    type = Type.GetType("System.UInt16");
                    break;
                }
                case 8: {
                    type = Type.GetType("System.Int32");
                    break;
                }
                case 9: {
                    type = Type.GetType("System.UInt32");
                    break;
                }
                case 10: {
                    type = Type.GetType("System.Int64");
                    break;
                }
                case 11: {
                    type = Type.GetType("System.UInt64");
                    break;
                }
                case 12: {
                    type = Type.GetType("System.Single");
                    break;
                }
                case 13: {
                    type = Type.GetType("System.Double");
                    break;
                }
                case 28: {
                    type = Type.GetType("System.Object");
                    break;
                }
                case 14: {
                    type = Type.GetType("System.String");
                    break;
                }
                case 24: {
                    type = Type.GetType("System.IntPtr");
                    break;
                }
                case 25: {
                    type = Type.GetType("System.UIntPtr");
                    break;
                }
                case 15: {
                    if (this.getByte() == 1) {
                        this.readByte();
                        type = Type.mkPtr(Type.GetType("System.Void"));
                        break;
                    }
                    type = Type.mkPtr(this.decodeType());
                    break;
                }
                case 16: {
                    type = Type.mkByRef(this.decodeType());
                    break;
                }
                case 17: 
                case 18: {
                    type = PEFile.this.pemodule.getTypeDefOrRef(this.decodeInt());
                    if (type != null) break;
                    throw new RuntimeException();
                }
                case 29: {
                    this.skipCustomMods();
                    type = Type.mkArray(this.decodeType(), 1);
                    break;
                }
                case 20: {
                    Type elem2 = this.decodeType();
                    int rank = this.decodeInt();
                    int numSizes = this.decodeInt();
                    for (int i = 0; i < numSizes; ++i) {
                        this.decodeInt();
                    }
                    int numLoBounds = this.decodeInt();
                    for (int i = 0; i < numLoBounds; ++i) {
                        this.decodeInt();
                    }
                    type = Type.mkArray(elem2, rank);
                    break;
                }
                case 21: {
                    int b = this.readByte();
                    Type instantiatedType = PEFile.this.pemodule.getTypeDefOrRef(this.decodeInt());
                    int numberOfTypeArgs = this.decodeInt();
                    Type[] typeArgs2 = new Type[numberOfTypeArgs];
                    for (int iarg = 0; iarg < numberOfTypeArgs; ++iarg) {
                        typeArgs2[iarg] = this.decodeType();
                    }
                    type = new ConstructedType(instantiatedType, typeArgs2);
                    break;
                }
                case 19: {
                    int typeArgAsZeroBased = this.decodeInt();
                    type = new Type.TMVarUsage(typeArgAsZeroBased, true);
                    break;
                }
                case 30: {
                    int typeArgAsZeroBased = this.decodeInt();
                    type = new Type.TMVarUsage(typeArgAsZeroBased, false);
                    break;
                }
                default: {
                    throw new RuntimeException(PEFile.byte2hex(desc) + "@" + this.pos() + " in " + this);
                }
            }
            if (type == null) {
                throw new RuntimeException();
            }
            return type;
        }

        public PECustomMod decodeFieldType() {
            this.skipByte(6);
            CustomModifier[] cmods = this.getCustomMods();
            Type fieldType = this.decodeType();
            return new PECustomMod(fieldType, cmods);
        }

        public Type decodeRetType() {
            this.skipCustomMods();
            switch (this.getByte()) {
                case 1: {
                    this.readByte();
                    return Type.GetType("System.Void");
                }
                case 22: {
                    return Type.GetType("System.TypedReference");
                }
                case 16: {
                    return this.decodeType();
                }
            }
            return this.decodeType();
        }

        public Type decodeParamType() {
            this.skipCustomMods();
            switch (this.getByte()) {
                case 16: {
                    return this.decodeType();
                }
                case 22: {
                    return Type.GetType("System.TypedReference");
                }
            }
            return this.decodeType();
        }

        public void skipCustomMods() {
            while (this.getByte() == 32 || this.getByte() == 31) {
                boolean isREQD = this.getByte() == 31;
                this.readByte();
                Type ignored = PEFile.this.pemodule.getTypeDefOrRef(this.decodeInt());
                if (!isREQD) continue;
            }
        }

        public CustomModifier[] getCustomMods() {
            LinkedList<CustomModifier> cmods = new LinkedList<CustomModifier>();
            while (this.getByte() == 32 || this.getByte() == 31) {
                boolean isReqd = this.getByte() == 31;
                this.readByte();
                Type t = PEFile.this.pemodule.getTypeDefOrRef(this.decodeInt());
                cmods.add(new CustomModifier(isReqd, t));
            }
            CustomModifier[] res = cmods.toArray(new CustomModifier[0]);
            return res;
        }
    }
}

