/*
 * Decompiled with CFR 0.152.
 */
package scala.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversable;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.runtime.Nothing$;
import scala.util.PropertiesTrait;
import scala.util.PropertiesTrait$;

public abstract class PropertiesTrait$class {
    /*
     * WARNING - void declaration
     */
    public static Properties scalaProps(PropertiesTrait $this) {
        void var1_1;
        Properties props = new Properties();
        InputStream stream = $this.pickJarBasedOn().getResourceAsStream($this.propFilename());
        if (stream != null) {
            PropertiesTrait$class.quietlyDispose($this, (Function0)((Object)new Serializable($this, props, stream){
                public static final long serialVersionUID = 0L;
                public final Properties props$1;
                public final InputStream stream$1;

                public final void apply() {
                    this.props$1.load(this.stream$1);
                }

                public void apply$mcV$sp() {
                    this.props$1.load(this.stream$1);
                }
                {
                    this.props$1 = props$1;
                    this.stream$1 = stream$1;
                }
            }), (Function0)((Object)new Serializable($this, stream){
                public static final long serialVersionUID = 0L;
                public final InputStream stream$1;

                public final void apply() {
                    this.stream$1.close();
                }

                public void apply$mcV$sp() {
                    this.stream$1.close();
                }
                {
                    this.stream$1 = stream$1;
                }
            }));
        }
        return var1_1;
    }

    private static void quietlyDispose(PropertiesTrait $this, Function0 action2, Function0 disposal) {
        try {
            action2.apply$mcV$sp();
        }
        catch (Throwable throwable2) {
            try {
                disposal.apply$mcV$sp();
            }
            catch (IOException iOException) {}
            throw throwable2;
        }
        try {
            disposal.apply$mcV$sp();
        }
        catch (IOException iOException) {}
    }

    public static boolean propIsSet(PropertiesTrait $this, String name) {
        return System.getProperty(name) != null;
    }

    public static boolean propIsSetTo(PropertiesTrait $this, String name, String value2) {
        String string2 = $this.propOrNull(name);
        return !(string2 != null ? !string2.equals(value2) : value2 != null);
    }

    public static String propOrElse(PropertiesTrait $this, String name, String alt) {
        return System.getProperty(name, alt);
    }

    public static String propOrEmpty(PropertiesTrait $this, String name) {
        return $this.propOrElse(name, "");
    }

    public static String propOrNull(PropertiesTrait $this, String name) {
        return $this.propOrElse(name, null);
    }

    public static Option propOrNone(PropertiesTrait $this, String name) {
        return Option$.MODULE$.apply($this.propOrNull(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean propOrFalse(PropertiesTrait $this, String name) {
        Option<String> option = $this.propOrNone(name);
        if (option.isEmpty()) return false;
        String string2 = option.get();
        WrappedArray<Object> wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yes", "on", "true"});
        List$ list$ = List$.MODULE$;
        if (!wrappedArray.toList().contains(string2.toLowerCase())) return false;
        return true;
    }

    public static String setProp(PropertiesTrait $this, String name, String value2) {
        return System.setProperty(name, value2);
    }

    public static String clearProp(PropertiesTrait $this, String name) {
        return System.clearProperty(name);
    }

    public static String envOrElse(PropertiesTrait $this, String name, String alt) {
        Option<String> option = Option$.MODULE$.apply(System.getenv(name));
        return option.isEmpty() ? alt : option.get();
    }

    public static Option envOrNone(PropertiesTrait $this, String name) {
        return Option$.MODULE$.apply(System.getenv(name));
    }

    public static String scalaPropOrElse(PropertiesTrait $this, String name, String alt) {
        return $this.scalaProps().getProperty(name, alt);
    }

    public static String scalaPropOrEmpty(PropertiesTrait $this, String name) {
        return $this.scalaPropOrElse(name, "");
    }

    public static Option scalaPropOrNone(PropertiesTrait $this, String name) {
        return Option$.MODULE$.apply($this.scalaProps().getProperty(name));
    }

    public static String versionNumberString(PropertiesTrait $this) {
        return $this.scalaPropOrEmpty("version.number");
    }

    public static String sourceEncoding(PropertiesTrait $this) {
        return $this.scalaPropOrElse("file.encoding", "UTF-8");
    }

    public static String sourceReader(PropertiesTrait $this) {
        return $this.scalaPropOrElse("source.reader", "scala.tools.nsc.io.SourceReader");
    }

    public static String encodingString(PropertiesTrait $this) {
        return $this.propOrElse("file.encoding", "UTF-8");
    }

    public static String lineSeparator(PropertiesTrait $this) {
        return $this.propOrElse("line.separator", "\n");
    }

    public static String javaClassPath(PropertiesTrait $this) {
        return $this.propOrEmpty("java.class.path");
    }

    public static String javaHome(PropertiesTrait $this) {
        return $this.propOrEmpty("java.home");
    }

    public static String javaVendor(PropertiesTrait $this) {
        return $this.propOrEmpty("java.vendor");
    }

    public static String javaVersion(PropertiesTrait $this) {
        return $this.propOrEmpty("java.version");
    }

    public static String javaVmInfo(PropertiesTrait $this) {
        return $this.propOrEmpty("java.vm.info");
    }

    public static String javaVmName(PropertiesTrait $this) {
        return $this.propOrEmpty("java.vm.name");
    }

    public static String javaVmVendor(PropertiesTrait $this) {
        return $this.propOrEmpty("java.vm.vendor");
    }

    public static String javaVmVersion(PropertiesTrait $this) {
        return $this.propOrEmpty("java.vm.version");
    }

    public static String osName(PropertiesTrait $this) {
        return $this.propOrEmpty("os.name");
    }

    public static String scalaHome(PropertiesTrait $this) {
        return $this.propOrEmpty("scala.home");
    }

    public static String tmpDir(PropertiesTrait $this) {
        return $this.propOrEmpty("java.io.tmpdir");
    }

    public static String userDir(PropertiesTrait $this) {
        return $this.propOrEmpty("user.dir");
    }

    public static String userHome(PropertiesTrait $this) {
        return $this.propOrEmpty("user.home");
    }

    public static String userName(PropertiesTrait $this) {
        return $this.propOrEmpty("user.name");
    }

    public static boolean isWin(PropertiesTrait $this) {
        return $this.osName().startsWith("Windows");
    }

    public static boolean isMac(PropertiesTrait $this) {
        return $this.javaVendor().startsWith("Apple");
    }

    public static String jdkHome(PropertiesTrait $this) {
        return $this.envOrElse("JDK_HOME", $this.envOrElse("JAVA_HOME", $this.javaHome()));
    }

    public static String versionMsg(PropertiesTrait $this) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("Scala %s %s -- %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{$this.propCategory(), $this.versionString(), $this.copyrightString()}));
    }

    public static String scalaCmd(PropertiesTrait $this) {
        return $this.isWin() ? "scala.bat" : "scala";
    }

    public static String scalacCmd(PropertiesTrait $this) {
        return $this.isWin() ? "scalac.bat" : "scalac";
    }

    public static boolean isJavaAtLeast(PropertiesTrait $this, String version) {
        GenTraversable<Nothing$> genTraversable = !("1.5" != null ? !"1.5".equals(version) : version != null) ? List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.5", "1.6", "1.7"})) : (!("1.6" != null ? !"1.6".equals(version) : version != null) ? List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.6", "1.7"})) : (!("1.7" != null ? !"1.7".equals(version) : version != null) ? List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.7"})) : Nil$.MODULE$));
        return genTraversable.exists((Function1<Nothing$, Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesTrait $outer;

            public final boolean apply(String x$1) {
                return this.$outer.javaVersion().startsWith(x$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public static void main(PropertiesTrait $this, String[] args2) {
        PrintWriter writer = new PrintWriter(Console$.MODULE$.err(), true);
        writer.println($this.versionMsg());
    }

    public static void $init$(PropertiesTrait $this) {
        $this.scala$util$PropertiesTrait$_setter_$propFilename_$eq(new StringBuilder().append((Object)"/").append((Object)$this.propCategory()).append((Object)".properties").toString());
        PropertiesTrait$.anonfun.1 var2_1 = new PropertiesTrait$.anonfun.1($this);
        Option<String> option = $this.scalaPropOrNone("maven.version.number");
        $this.scala$util$PropertiesTrait$_setter_$releaseVersion_$eq(new Option.WithFilter(option, var2_1).map(new PropertiesTrait$.anonfun.2($this)));
        PropertiesTrait$.anonfun.3 var4_3 = new PropertiesTrait$.anonfun.3($this);
        Option<String> option2 = $this.scalaPropOrNone("maven.version.number");
        $this.scala$util$PropertiesTrait$_setter_$developmentVersion_$eq(new Option.WithFilter(option2, var4_3).flatMap(new PropertiesTrait$.anonfun.4($this)));
        $this.scala$util$PropertiesTrait$_setter_$versionString_$eq(new StringBuilder().append((Object)"version ").append((Object)$this.scalaPropOrElse("version.number", "(unknown)")).toString());
        $this.scala$util$PropertiesTrait$_setter_$copyrightString_$eq($this.scalaPropOrElse("copyright.string", "Copyright 2002-2013, LAMP/EPFL"));
    }
}

