/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.asm;

import scala.tools.asm.AnnotationVisitor;
import scala.tools.asm.Attribute;
import scala.tools.asm.FieldVisitor;
import scala.tools.asm.MethodVisitor;

public abstract class ClassVisitor {
    protected final int api;
    protected ClassVisitor cv;

    public ClassVisitor(int api) {
        this(api, null);
    }

    public ClassVisitor(int api, ClassVisitor cv) {
        this.api = api;
        this.cv = cv;
    }

    public void visit(int version, int access, String name, String signature2, String superName, String[] interfaces2) {
        if (this.cv != null) {
            this.cv.visit(version, access, name, signature2, superName, interfaces2);
        }
    }

    public void visitSource(String source, String debug) {
        if (this.cv != null) {
            this.cv.visitSource(source, debug);
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (this.cv != null) {
            this.cv.visitOuterClass(owner, name, desc);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.cv != null) {
            return this.cv.visitAnnotation(desc, visible);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
        if (this.cv != null) {
            this.cv.visitAttribute(attr);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.cv != null) {
            this.cv.visitInnerClass(name, outerName, innerName, access);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature2, Object value2) {
        if (this.cv != null) {
            return this.cv.visitField(access, name, desc, signature2, value2);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature2, String[] exceptions) {
        if (this.cv != null) {
            return this.cv.visitMethod(access, name, desc, signature2, exceptions);
        }
        return null;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }
}

