/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import jline.Terminal;
import jline.TerminalFactory;
import sbt.ConsoleLogger;
import sbt.ConsoleLogger$;
import sbt.ConsoleOut;
import sbt.ConsoleOut$;
import sbt.SuppressedTraceContext;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class ConsoleLogger$ {
    public static final ConsoleLogger$ MODULE$;
    private final char ESC;
    private final boolean formatEnabled;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final Regex EscapeSequence;

    static {
        new ConsoleLogger$();
    }

    public ConsoleOut systemOut() {
        return ConsoleOut$.MODULE$.systemOut();
    }

    public Function2<String, String, Object> overwriteContaining(String s2) {
        return ConsoleOut$.MODULE$.overwriteContaining(s2);
    }

    public ConsoleOut systemOutOverwrite(Function2<String, String, Object> f2) {
        return ConsoleOut$.MODULE$.systemOutOverwrite(f2);
    }

    public ConsoleOut printStreamOut(PrintStream out) {
        return ConsoleOut$.MODULE$.printStreamOut(out);
    }

    public ConsoleOut printWriterOut(PrintWriter out) {
        return ConsoleOut$.MODULE$.printWriterOut(out);
    }

    public ConsoleOut bufferedWriterOut(BufferedWriter out) {
        while (true) {
            // Infinite loop
        }
    }

    public final char ESC() {
        return '\u001b';
    }

    public boolean isEscapeTerminator(char c) {
        return c >= '@' && c <= '~';
    }

    public boolean hasEscapeSequence(String s2) {
        return s2.indexOf(27) >= 0;
    }

    public String removeEscapeSequences(String s2) {
        String string2;
        if (!s2.isEmpty() && this.hasEscapeSequence(s2)) {
            StringBuilder sb = new StringBuilder();
            this.nextESC(s2, 0, sb);
            string2 = sb.toString();
        } else {
            string2 = s2;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void nextESC(String s2, int start, StringBuilder sb) {
        while (true) {
            int next2;
            void var5_4;
            int escIndex;
            if ((escIndex = s2.indexOf(27, start)) < 0) {
                sb.append(s2, start, s2.length());
                return;
            }
            sb.append(s2, start, (int)var5_4);
            start = next2 = this.skipESC(s2, (int)(var5_4 + true));
        }
    }

    private int skipESC(String s2, int i) {
        while (true) {
            block5: {
                int n;
                block4: {
                    block3: {
                        if (i < s2.length()) break block3;
                        n = i;
                        break block4;
                    }
                    if (!this.isEscapeTerminator(s2.charAt(i))) break block5;
                    n = i + 1;
                }
                return n;
            }
            ++i;
        }
    }

    public boolean formatEnabled() {
        return this.formatEnabled;
    }

    private String jline1to2CompatMsg() {
        return "Found class jline.Terminal, but interface was expected";
    }

    private boolean ansiSupported() {
        Throwable throwable2;
        Throwable throwable32;
        block4: {
            boolean bl;
            try {
                Terminal terminal2 = TerminalFactory.get();
                terminal2.restore();
                bl = terminal2.isAnsiSupported();
            }
            catch (Throwable throwable32) {
                boolean bl2;
                throwable2 = throwable32;
                if (!(throwable2 instanceof Exception)) break block4;
                bl = bl2 = !this.isWindows();
            }
            return bl;
        }
        if (throwable2 instanceof IncompatibleClassChangeError) {
            IncompatibleClassChangeError incompatibleClassChangeError = (IncompatibleClassChangeError)throwable2;
            String string2 = incompatibleClassChangeError.getMessage();
            String string3 = this.jline1to2CompatMsg();
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                throw new IncompatibleClassChangeError("JLine incompatibility detected.  Check that the sbt launcher is version 0.13.x or later.");
            }
        }
        throw throwable32;
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase().indexOf("windows") >= 0;
    }

    public ConsoleLogger apply(PrintStream out) {
        return this.apply(ConsoleOut$.MODULE$.printStreamOut(out), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public ConsoleLogger apply(PrintWriter out) {
        return this.apply(ConsoleOut$.MODULE$.printWriterOut(out), this.apply$default$2(), this.apply$default$3(), this.apply$default$4());
    }

    public ConsoleLogger apply(ConsoleOut out, boolean ansiCodesSupported, boolean useColor, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleLogger(out, ansiCodesSupported, useColor, suppressedMessage);
    }

    public ConsoleOut apply$default$1() {
        return ConsoleOut$.MODULE$.systemOut();
    }

    public boolean apply$default$2() {
        return this.formatEnabled();
    }

    public boolean apply$default$3() {
        return this.formatEnabled();
    }

    public Function1<SuppressedTraceContext, Option<String>> apply$default$4() {
        return this.noSuppressedMessage();
    }

    public String stripEscapeSequences(String s2) {
        return this.EscapeSequence.pattern().matcher(s2).replaceAll("");
    }

    private ConsoleLogger$() {
        MODULE$ = this;
        String value2 = System.getProperty("sbt.log.format");
        this.formatEnabled = value2 == null ? this.ansiSupported() && !Boolean.getBoolean("sbt.log.noformat") : Boolean.parseBoolean(value2);
        this.noSuppressedMessage = new anonfun.1();
        this.EscapeSequence = new StringOps(Predef$.MODULE$.augmentString(new scala.collection.mutable.StringBuilder().append((char)27).append((Object)"[^@-~]*[@-~]").toString())).r();
    }
}

