/*
 * Decompiled with CFR 0.152.
 */
package sbt.classpath;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import sbt.DirectoryFilter$;
import sbt.IO$;
import sbt.Path$;
import sbt.PathFinder;
import sbt.ScalaInstance;
import sbt.SimpleFileFilter;
import sbt.classpath.ClasspathFilter;
import sbt.classpath.ClasspathUtilities$;
import sbt.classpath.FixedResources$class;
import sbt.classpath.NativeCopyConfig;
import sbt.classpath.NativeCopyLoader$class;
import sbt.classpath.RawResources;
import sbt.classpath.RawResources$class;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.tools.nsc.GenericRunnerCommand;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.settings.MutableSettings;
import xsbti.Launcher;

public final class ClasspathUtilities$ {
    public static final ClasspathUtilities$ MODULE$;
    private ClassLoader rootLoader;
    private ClassLoader xsbtiLoader;
    private final String AppClassPath;
    private final String BootClassPath;
    private Tuple2<Set<File>, Set<File>> x$9;
    private Set<File> extraJars;
    private Set<File> extraDirs;
    private volatile byte bitmap$0;

    static {
        new ClasspathUtilities$();
    }

    private ClassLoader rootLoader$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                this.rootLoader = systemLoader != null ? this.parent$1(systemLoader) : this.parent$1(this.getClass().getClassLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.rootLoader;
        }
    }

    private ClassLoader xsbtiLoader$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xsbtiLoader = Launcher.class.getClassLoader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.xsbtiLoader;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$9$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                GenericRunnerSettings settings = new GenericRunnerCommand((List)Nil$.MODULE$, (Function1)new anonfun.1()).settings();
                List bootPaths = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.pathSplit(((MutableSettings.PathSetting)settings.bootclasspath()).value())).map((Function1)new anonfun.2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).toList();
                Tuple2<Iterable<File>, Iterable<File>> tuple23 = this.separate((Iterable<File>)bootPaths);
                if (tuple23 == null) throw new MatchError(tuple23);
                Iterable bootJars = (Iterable)tuple23._1();
                Iterable bootDirs = (Iterable)tuple23._2();
                Tuple2 tuple24 = tuple22 = new Tuple2((Object)bootJars, (Object)bootDirs);
                Iterable bootJars2 = (Iterable)tuple24._1();
                Iterable bootDirs2 = (Iterable)tuple24._2();
                ListBuffer buffer = new ListBuffer();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])IO$.MODULE$.pathSplit(((MutableSettings.PathSetting)settings.extdirs()).value())).map((Function1)new anonfun.3(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new anonfun.4()).foreach((Function1)new anonfun.5(buffer));
                List extJars = (List)buffer.readOnly().map((Function1)new anonfun.6(), List$.MODULE$.canBuildFrom());
                Tuple2 tuple25 = new Tuple2(this.linkedSet((Iterable)extJars.$plus$plus((GenTraversableOnce)bootJars2, List$.MODULE$.canBuildFrom())), this.linkedSet(bootDirs2));
                if (tuple25 == null) throw new MatchError((Object)tuple25);
                Set extraJars = (Set)tuple25._1();
                Set extraDirs = (Set)tuple25._2();
                this.x$9 = tuple2 = new Tuple2((Object)extraJars, (Object)extraDirs);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.x$9;
        }
    }

    private Set extraJars$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.extraJars = (Set)this.x$9()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.extraJars;
        }
    }

    private Set extraDirs$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.extraDirs = (Set)this.x$9()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.extraDirs;
        }
    }

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<File> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent) {
        return new URLClassLoader(Path$.MODULE$.toURLs(paths), parent);
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap) {
        return new RawResources(paths, parent, resourceMap){
            private final Map resourceMap$2;
            private final Map<String, URL> resourceURL;

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$classpath$RawResources$_setter_$resourceURL_$eq(Map x$1) {
                this.resourceURL = x$1;
            }

            public URL sbt$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public Enumeration sbt$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources$class.findResource(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources$class.findResources(this, s);
            }

            public Map<String, String> resources() {
                return this.resourceMap$2;
            }
            {
                this.resourceMap$2 = resourceMap$2;
                super(Path$.MODULE$.toURLs((Seq<File>)paths$2), parent$3);
                FixedResources$class.$init$(this);
                RawResources$class.$init$(this);
            }
        };
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap, File nativeTemp) {
        return new RawResources(paths, parent, resourceMap, nativeTemp){
            private final NativeCopyConfig config;
            private final Map resourceMap$1;
            private final HashMap sbt$classpath$NativeCopyLoader$$mapped;
            private final Map<String, URL> resourceURL;

            public HashMap sbt$classpath$NativeCopyLoader$$mapped() {
                return this.sbt$classpath$NativeCopyLoader$$mapped;
            }

            public void sbt$classpath$NativeCopyLoader$_setter_$sbt$classpath$NativeCopyLoader$$mapped_$eq(HashMap x$1) {
                this.sbt$classpath$NativeCopyLoader$$mapped = x$1;
            }

            public String findLibrary(String name) {
                return NativeCopyLoader$class.findLibrary(this, name);
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$classpath$RawResources$_setter_$resourceURL_$eq(Map x$1) {
                this.resourceURL = x$1;
            }

            public URL sbt$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public Enumeration sbt$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources$class.findResource(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources$class.findResources(this, s);
            }

            public Map<String, String> resources() {
                return this.resourceMap$1;
            }

            public NativeCopyConfig config() {
                return this.config;
            }
            {
                this.resourceMap$1 = resourceMap$1;
                super(Path$.MODULE$.toURLs((Seq<File>)paths$1), parent$2);
                FixedResources$class.$init$(this);
                RawResources$class.$init$(this);
                NativeCopyLoader$class.$init$(this);
                this.config = new NativeCopyConfig(nativeTemp$1, (Seq<File>)paths$1, ClasspathUtilities$.MODULE$.javaLibraryPaths());
            }
        };
    }

    public Seq<File> javaLibraryPaths() {
        return IO$.MODULE$.parseClasspath(System.getProperty("java.library.path"));
    }

    public ClassLoader rootLoader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rootLoader$lzycompute() : this.rootLoader;
    }

    public ClassLoader xsbtiLoader() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.xsbtiLoader$lzycompute() : this.xsbtiLoader;
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<File> classpath, ScalaInstance instance) {
        return this.createClasspathResources(classpath, (Seq<File>)instance.jars());
    }

    public Map<String, String> createClasspathResources(Seq<File> appPaths, Seq<File> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.make$1("app.class.path", appPaths), this.make$1("boot.class.path", bootPaths)}));
    }

    public ClassLoader filterByClasspath(Seq<File> classpath, ClassLoader loader) {
        return new ClasspathFilter(loader, this.xsbtiLoader(), (scala.collection.immutable.Set<File>)classpath.toSet());
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loader(), instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance, File nativeTemp) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loader(), instance, nativeTemp));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance, File nativeTemp) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance), nativeTemp);
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)c.getName()).append((Object)" loader=").append((Object)c.getClassLoader()).append((Object)" location=").append((Object)IO$.MODULE$.classLocationFile(c)).toString());
    }

    public boolean isArchive(File file) {
        return this.isArchiveName(file.getName());
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public Tuple2<Iterable<File>, Iterable<File>> separate(Iterable<File> paths) {
        return paths.partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return ClasspathUtilities$.MODULE$.isArchive(file);
            }
        });
    }

    public Tuple2<Set<File>, Set<File>> buildSearchPaths(Iterable<File> classpath) {
        Tuple2<Iterable<File>, Iterable<File>> tuple2 = this.separate(classpath);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterable jars = (Iterable)tuple2._1();
            Iterable dirs2 = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jars, (Object)dirs2);
            Iterable jars2 = (Iterable)tuple23._1();
            Iterable dirs3 = (Iterable)tuple23._2();
            return new Tuple2(this.linkedSet((Iterable)jars2.$plus$plus(this.extraJars(), Iterable$.MODULE$.canBuildFrom())), this.linkedSet((Iterable)dirs3.$plus$plus(this.extraDirs(), Iterable$.MODULE$.canBuildFrom())));
        }
        throw new MatchError(tuple2);
    }

    public boolean onClasspath(Set<File> classpathJars, Set<File> classpathDirectories, File file) {
        File f2 = file.getCanonicalFile();
        return this.isArchive(f2) ? classpathJars.apply((Object)f2) : classpathDirectories.toList().find((Function1)new Serializable(f2){
            public static final long serialVersionUID = 0L;
            private final File f$1;

            public final boolean apply(File x$2) {
                return Path$.MODULE$.relativize(x$2, this.f$1).isDefined();
            }
            {
                this.f$1 = f$1;
            }
        }).isDefined();
    }

    public Iterable<File> compilerPlugins(Seq<File> classpath) {
        URLClassLoader loader = new URLClassLoader(Path$.MODULE$.toURLs(classpath));
        return (Iterable)JavaConversions$.MODULE$.enumerationAsScalaIterator(loader.getResources("scalac-plugin.xml")).toList().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<File> apply(URL url) {
                return ClasspathUtilities$.MODULE$.asFile(true, url);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<File> asFile(URL url) {
        return this.asFile(false, url);
    }

    public List<File> asFile(boolean jarOnly, URL url) {
        Nil$ nil$;
        try {
            List list2;
            String string;
            String string2 = string = url.getProtocol();
            if (!("file" != null ? !"file".equals(string2) : string2 != null) && !jarOnly) {
                File file = IO$.MODULE$.toFile(url);
                list2 = Nil$.MODULE$.$colon$colon((Object)file);
            } else {
                String string3 = string;
                if (!("jar" != null ? !"jar".equals(string3) : string3 != null)) {
                    String path2 = url.getPath();
                    int end = path2.indexOf(33);
                    File file = new File(new URI(end == -1 ? path2 : path2.substring(0, end)));
                    list2 = Nil$.MODULE$.$colon$colon((Object)file);
                } else {
                    list2 = Nil$.MODULE$;
                }
            }
            nil$ = list2;
        }
        catch (Exception exception) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private Tuple2<Set<File>, Set<File>> x$9() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.x$9$lzycompute() : this.x$9;
    }

    private Set<File> extraJars() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.extraJars$lzycompute() : this.extraJars;
    }

    private Set<File> extraDirs() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.extraDirs$lzycompute() : this.extraDirs;
    }

    /*
     * WARNING - void declaration
     */
    private <T> Set<T> linkedSet(Iterable<T> s) {
        void var2_2;
        scala.collection.mutable.Set set2 = JavaConversions$.MODULE$.asScalaSet(new LinkedHashSet());
        set2.$plus$plus$eq(s);
        return var2_2;
    }

    private final ClassLoader parent$1(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private final Tuple2 make$1(String name, Seq paths) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)name), (Object)Path$.MODULE$.makeString((Seq<File>)paths));
    }

    public final void sbt$classpath$ClasspathUtilities$$findJars$1(File dir, ListBuffer buffer$1) {
        buffer$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])dir.listFiles(new SimpleFileFilter((Function1<File, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return ClasspathUtilities$.MODULE$.isArchive(file);
            }
        }))));
        Predef$.MODULE$.refArrayOps((Object[])dir.listFiles(DirectoryFilter$.MODULE$)).foreach((Function1)new Serializable(buffer$1){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$1;

            public final void apply(File dir) {
                ClasspathUtilities$.MODULE$.sbt$classpath$ClasspathUtilities$$findJars$1(dir, this.buffer$1);
            }
            {
                this.buffer$1 = buffer$1;
            }
        });
    }

    private ClasspathUtilities$() {
        MODULE$ = this;
    }
}

