/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import com.metamx.metrics.KeyedDiff;
import com.metamx.metrics.MonitorUtils;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;

public class JvmMonitor
extends AbstractMonitor {
    private final KeyedDiff gcDiff = new KeyedDiff();
    private Map<String, String[]> dimensions;

    public JvmMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmMonitor(Map<String, String[]> dimensions) {
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap usages = ImmutableMap.of((Object)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), (Object)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = new ServiceMetricEvent.Builder().setDimension("memKind", kind);
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/mem/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/mem/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/mem/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/mem/init", (Number)usage.getInit()));
        }
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = memoryPoolMXBean.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = memoryPoolMXBean.getUsage();
            builder = new ServiceMetricEvent.Builder().setDimension("poolKind", kind).setDimension("poolName", memoryPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.build("jvm/pool/max", (Number)usage.getMax()));
            emitter.emit(builder.build("jvm/pool/committed", (Number)usage.getCommitted()));
            emitter.emit(builder.build("jvm/pool/used", (Number)usage.getUsed()));
            emitter.emit(builder.build("jvm/pool/init", (Number)usage.getInit()));
        }
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            Map<String, Long> diff = this.gcDiff.to(garbageCollectorMXBean.getName(), (Map<String, Long>)ImmutableMap.of((Object)"jvm/gc/time", (Object)garbageCollectorMXBean.getCollectionTime(), (Object)"jvm/gc/count", (Object)garbageCollectorMXBean.getCollectionCount()));
            if (diff == null) continue;
            ServiceMetricEvent.Builder builder2 = new ServiceMetricEvent.Builder().setDimension("gcName", garbageCollectorMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder2, this.dimensions);
            for (Map.Entry<String, Long> entry : diff.entrySet()) {
                emitter.emit(builder2.build(entry.getKey(), (Number)entry.getValue()));
            }
        }
        for (BufferPoolMXBean bufferPoolMXBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            ServiceMetricEvent.Builder builder3 = new ServiceMetricEvent.Builder().setDimension("bufferpoolName", bufferPoolMXBean.getName());
            MonitorUtils.addDimensionsToBuilder(builder3, this.dimensions);
            emitter.emit(builder3.build("jvm/bufferpool/capacity", (Number)bufferPoolMXBean.getTotalCapacity()));
            emitter.emit(builder3.build("jvm/bufferpool/used", (Number)bufferPoolMXBean.getMemoryUsed()));
            emitter.emit(builder3.build("jvm/bufferpool/count", (Number)bufferPoolMXBean.getCount()));
        }
        return true;
    }
}

