/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Throwables;
import com.metamx.common.StreamUtils;
import com.metamx.common.logger.Logger;
import com.metamx.metrics.SysMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarLoader;

public class SigarUtil {
    private static final Logger log = new Logger(SigarUtil.class);

    public static Sigar getSigar() {
        return new Sigar();
    }

    public static long getCurrentProcessId() {
        return CurrentProcessIdHolder.currentProcessId;
    }

    static {
        SigarLoader loader = new SigarLoader(Sigar.class);
        try {
            String libName = loader.getLibraryName();
            URL url = SysMonitor.class.getResource("/" + libName);
            if (url != null) {
                File tmpDir = Files.createTempDirectory("sigar", new FileAttribute[0]).toFile();
                tmpDir.deleteOnExit();
                File nativeLibTmpFile = new File(tmpDir, libName);
                nativeLibTmpFile.deleteOnExit();
                StreamUtils.copyToFileAndClose(url.openStream(), nativeLibTmpFile);
                log.info("Loading sigar native lib at tmpPath[%s]", nativeLibTmpFile);
                loader.load(nativeLibTmpFile.getParent());
            } else {
                log.info("No native libs found in jar, letting the normal load mechanisms figger it out.", new Object[0]);
            }
        }
        catch (IOException | ArchLoaderException | ArchNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class CurrentProcessIdHolder {
        private static final long currentProcessId = new Sigar().getPid();

        private CurrentProcessIdHolder() {
        }
    }
}

