/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.FeedDefiningMonitor;
import com.metamx.metrics.MonitorUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;

public class JvmThreadsMonitor
extends FeedDefiningMonitor {
    private final Map<String, String[]> dimensions;
    private int lastLiveThreads = 0;
    private long lastStartedThreads = 0L;

    public JvmThreadsMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmThreadsMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public JvmThreadsMonitor(Map<String, String[]> dimensions, String feed) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        int newLiveThreads = threadBean.getThreadCount();
        long newStartedThreads = threadBean.getTotalStartedThreadCount();
        long startedThreadsDiff = newStartedThreads - this.lastStartedThreads;
        emitter.emit(builder.build("jvm/threads/started", startedThreadsDiff));
        emitter.emit(builder.build("jvm/threads/finished", (long)this.lastLiveThreads + startedThreadsDiff - (long)newLiveThreads));
        emitter.emit(builder.build("jvm/threads/live", newLiveThreads));
        emitter.emit(builder.build("jvm/threads/liveDaemon", threadBean.getDaemonThreadCount()));
        emitter.emit(builder.build("jvm/threads/livePeak", threadBean.getPeakThreadCount()));
        threadBean.resetPeakThreadCount();
        this.lastStartedThreads = newStartedThreads;
        this.lastLiveThreads = newLiveThreads;
        return true;
    }
}

