/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.metrics;

import com.google.common.collect.ImmutableMap;
import com.metamx.emitter.core.ConcurrentTimeCounter;
import com.metamx.emitter.core.HttpPostEmitter;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.FeedDefiningMonitor;

public class HttpPostEmitterMonitor
extends FeedDefiningMonitor {
    private final HttpPostEmitter httpPostEmitter;
    private final ImmutableMap<String, String> extraDimensions;
    private final ServiceMetricEvent.Builder builder;
    private long lastTotalEmittedEvents = 0L;
    private int lastDroppedBuffers = 0;

    public HttpPostEmitterMonitor(String feed, HttpPostEmitter httpPostEmitter, ImmutableMap<String, String> extraDimensions) {
        super(feed);
        this.httpPostEmitter = httpPostEmitter;
        this.extraDimensions = extraDimensions;
        this.builder = this.builder();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        long newTotalEmittedEvents = this.httpPostEmitter.getTotalEmittedEvents();
        long totalEmittedEventsDiff = newTotalEmittedEvents - this.lastTotalEmittedEvents;
        emitter.emit(this.builder.build("emitter/events/emitted", totalEmittedEventsDiff));
        this.lastTotalEmittedEvents = newTotalEmittedEvents;
        int newDroppedBuffers = this.httpPostEmitter.getDroppedBuffers();
        int droppedBuffersDiff = newDroppedBuffers - this.lastDroppedBuffers;
        emitter.emit(this.builder.build("emitter/buffers/dropped", droppedBuffersDiff));
        this.lastDroppedBuffers = newDroppedBuffers;
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getBatchFillingTimeCounter(), "emitter/batchFilling/");
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getSuccessfulSendingTimeCounter(), "emitter/successfulSending/");
        this.emitTimeCounterMetrics(emitter, this.httpPostEmitter.getFailedSendingTimeCounter(), "emitter/failedSending/");
        emitter.emit(this.builder.build("emitter/events/emitQueue", this.httpPostEmitter.getEventsToEmit()));
        emitter.emit(this.builder.build("emitter/events/large/emitQueue", this.httpPostEmitter.getLargeEventsToEmit()));
        emitter.emit(this.builder.build("emitter/buffers/totalAllocated", this.httpPostEmitter.getTotalAllocatedBuffers()));
        emitter.emit(this.builder.build("emitter/buffers/emitQueue", this.httpPostEmitter.getBuffersToEmit()));
        emitter.emit(this.builder.build("emitter/buffers/failed", this.httpPostEmitter.getFailedBuffers()));
        emitter.emit(this.builder.build("emitter/buffers/reuseQueue", this.httpPostEmitter.getBuffersToReuse()));
        return true;
    }

    private void emitTimeCounterMetrics(ServiceEmitter emitter, ConcurrentTimeCounter timeCounter, String metricNameBase) {
        long timeSumAndCount = timeCounter.getTimeSumAndCountAndReset();
        emitter.emit(this.builder.build(metricNameBase + "timeMsSum", ConcurrentTimeCounter.timeSum(timeSumAndCount)));
        emitter.emit(this.builder.build(metricNameBase + "count", ConcurrentTimeCounter.count(timeSumAndCount)));
        emitter.emit(this.builder.build(metricNameBase + "maxTimeMs", timeCounter.getAndResetMaxTime()));
        emitter.emit(this.builder.build(metricNameBase + "minTimeMs", timeCounter.getAndResetMinTime()));
    }

    @Override
    protected ServiceMetricEvent.Builder builder() {
        ServiceMetricEvent.Builder builder = super.builder();
        this.extraDimensions.forEach(builder::setDimension);
        return builder;
    }
}

