/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.collect.Lists;
import com.metamx.common.guava.MergeIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class MergeIterable<T>
implements Iterable<T> {
    private final Comparator<T> comparator;
    private final Iterable<Iterable<T>> baseIterables;

    public MergeIterable(Comparator<T> comparator, Iterable<Iterable<T>> baseIterables) {
        this.comparator = comparator;
        this.baseIterables = baseIterables;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList iterators = Lists.newArrayList();
        for (Iterable<T> baseIterable : this.baseIterables) {
            iterators.add(baseIterable.iterator());
        }
        return new MergeIterator<T>(this.comparator, iterators);
    }
}

