/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.alpn.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import wiremock.org.eclipse.jetty.io.ClientConnectionFactory;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.NegotiatingClientConnection;
import wiremock.org.eclipse.jetty.util.log.Log;
import wiremock.org.eclipse.jetty.util.log.Logger;

public class ALPNClientConnection
extends NegotiatingClientConnection {
    private static final Logger LOG = Log.getLogger(ALPNClientConnection.class);
    private final List<String> protocols;

    public ALPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, List<String> protocols) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocols = protocols;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void selected(String protocol) {
        if (protocol == null || !this.protocols.contains(protocol)) {
            this.close();
        } else {
            super.completed();
        }
    }
}

