/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import java.io.IOException;
import wiremock.javax.servlet.Filter;
import wiremock.javax.servlet.FilterChain;
import wiremock.javax.servlet.FilterConfig;
import wiremock.javax.servlet.ServletContext;
import wiremock.javax.servlet.ServletException;
import wiremock.javax.servlet.ServletRequest;
import wiremock.javax.servlet.ServletResponse;
import wiremock.javax.servlet.http.HttpServletRequest;
import wiremock.javax.servlet.http.HttpServletResponse;

public class ContentTypeSettingFilter
implements Filter {
    private ServletContext context;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            String filePath = ((HttpServletRequest)request).getRequestURI();
            String contentType = this.context.getMimeType(filePath);
            if (contentType == null) {
                contentType = "application/json";
            }
            ((HttpServletResponse)response).setContentType(contentType);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

