/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.debug.mirror;

import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.debug.mirror.FunctionMirror;
import com.eclipsesource.v8.debug.mirror.Mirror;
import com.eclipsesource.v8.debug.mirror.Scope;
import com.eclipsesource.v8.debug.mirror.SourceLocation;
import com.eclipsesource.v8.debug.mirror.ValueMirror;

public class Frame
extends Mirror {
    private static final String END = "end";
    private static final String START = "start";
    private static final String COLUMN = "column";
    private static final String LINE = "line";
    private static final String POSITION = "position";
    private static final String NAME = "name";
    private static final String SCRIPT = "script";
    private static final String SCOPE = "scope";
    private static final String ARGUMENT_VALUE = "argumentValue";
    private static final String ARGUMENT_NAME = "argumentName";
    private static final String LOCAL_COUNT = "localCount";
    private static final String ARGUMENT_COUNT = "argumentCount";
    private static final String SCOPE_COUNT = "scopeCount";
    private static final String LOCAL_NAME = "localName";
    private static final String LOCAL_VALUE = "localValue";
    private static final String SOURCE_LOCATION = "sourceLocation";

    public Frame(V8Object v8Object) {
        super(v8Object);
    }

    public int getScopeCount() {
        return this.v8Object.executeIntegerFunction(SCOPE_COUNT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceLocation getSourceLocation() {
        V8Object sourceLocation = this.v8Object.executeObjectFunction(SOURCE_LOCATION, null);
        try {
            V8Object scriptObject = (V8Object)sourceLocation.get(SCRIPT);
            String scriptName = scriptObject.getString(NAME);
            scriptObject.release();
            SourceLocation sourceLocation2 = new SourceLocation(scriptName, sourceLocation.getInteger(POSITION), sourceLocation.getInteger(LINE), sourceLocation.getInteger(COLUMN), sourceLocation.getInteger(START), sourceLocation.getInteger(END));
            return sourceLocation2;
        }
        finally {
            sourceLocation.release();
        }
    }

    public int getArgumentCount() {
        return this.v8Object.executeIntegerFunction(ARGUMENT_COUNT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArgumentName(int index) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(index);
        try {
            String string = this.v8Object.executeStringFunction(ARGUMENT_NAME, parameters);
            return string;
        }
        finally {
            parameters.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueMirror getArgumentValue(int index) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(index);
        V8Object result = null;
        try {
            result = this.v8Object.executeObjectFunction(ARGUMENT_VALUE, parameters);
            if (!Frame.isValue(result)) {
                throw new IllegalStateException("Argument value is not a ValueMirror");
            }
            ValueMirror valueMirror = new ValueMirror(result);
            return valueMirror;
        }
        finally {
            parameters.release();
            if (result != null) {
                result.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueMirror getLocalValue(int index) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(index);
        V8Object result = null;
        try {
            result = this.v8Object.executeObjectFunction(LOCAL_VALUE, parameters);
            if (!Frame.isValue(result)) {
                throw new IllegalStateException("Local value is not a ValueMirror");
            }
            ValueMirror valueMirror = Frame.createMirror(result);
            return valueMirror;
        }
        finally {
            parameters.release();
            if (result != null) {
                result.release();
            }
        }
    }

    public int getLocalCount() {
        return this.v8Object.executeIntegerFunction(LOCAL_COUNT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalName(int index) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(index);
        try {
            String string = this.v8Object.executeStringFunction(LOCAL_NAME, parameters);
            return string;
        }
        finally {
            parameters.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope getScope(int index) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(index);
        V8Object scope = null;
        try {
            scope = this.v8Object.executeObjectFunction(SCOPE, parameters);
            Scope scope2 = new Scope(scope);
            return scope2;
        }
        finally {
            parameters.release();
            if (scope != null) {
                scope.release();
            }
        }
    }

    public FunctionMirror getFunction() {
        V8Object function = null;
        try {
            function = this.v8Object.executeObjectFunction("func", null);
            FunctionMirror functionMirror = new FunctionMirror(function);
            return functionMirror;
        }
        finally {
            if (function != null) {
                function.release();
            }
        }
    }

    @Override
    public boolean isFrame() {
        return true;
    }
}

