/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Value;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class V8ArrayBuffer
extends V8Value {
    private ByteBuffer byteBuffer;

    public V8ArrayBuffer(V8 v8, int capacity) {
        super(v8);
        this.initialize(v8.getV8RuntimePtr(), capacity);
        this.byteBuffer = v8.createV8ArrayBufferBackingStore(v8.getV8RuntimePtr(), this.objectHandle, capacity);
        this.byteBuffer.order(ByteOrder.nativeOrder());
    }

    public V8ArrayBuffer(V8 v8, ByteBuffer byteBuffer) {
        super(v8);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("ByteBuffer must be a allocated as a direct ByteBuffer");
        }
        this.initialize(v8.getV8RuntimePtr(), byteBuffer);
        this.byteBuffer = byteBuffer;
        byteBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    protected void initialize(long runtimePtr, Object data) {
        this.v8.checkThread();
        if (data instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)data;
            int capacity = buffer.limit();
            this.objectHandle = this.v8.initNewV8ArrayBuffer(this.v8.getV8RuntimePtr(), buffer, capacity);
        } else {
            int capacity = (Integer)data;
            this.objectHandle = this.v8.initNewV8ArrayBuffer(this.v8.getV8RuntimePtr(), capacity);
        }
        this.released = false;
        this.addObjectReference(this.objectHandle);
    }

    @Override
    protected V8Value createTwin() {
        return new V8ArrayBuffer(this.v8, this.byteBuffer);
    }

    @Override
    public V8ArrayBuffer twin() {
        return (V8ArrayBuffer)super.twin();
    }

    public ByteBuffer getBackingStore() {
        this.v8.checkReleased();
        this.v8.checkThread();
        return this.byteBuffer;
    }
}

