/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.transport;

import cn.ucloud.common.exception.TransportException;
import cn.ucloud.common.exception.UCloudException;
import cn.ucloud.common.request.Request;
import cn.ucloud.common.response.Response;
import cn.ucloud.common.transport.Transport;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DefaultTransport
implements Transport {
    private static final String HEADER_REQUEST_ID = "X-UCLOUD-REQUEST-UUID";
    private String baseUrl;
    private String userAgent;
    private CloseableHttpClient httpClient;

    public DefaultTransport(String baseUrl, String userAgent) {
        this.setBaseUrl(baseUrl);
        this.setUserAgent(userAgent);
        this.httpClient = HttpClients.createDefault();
    }

    @Override
    public Response invoke(Request request, Class<? extends Response> clazz) throws UCloudException {
        StatusLine httpStatus;
        CloseableHttpResponse httpResponse;
        HttpPost httpPost = new HttpPost(this.getBaseUrl());
        String ua = String.format("Java/%s Java-SDK/%s", System.getProperty("java.version"), "1.0.0");
        if (!StringUtils.isEmpty((CharSequence)this.getUserAgent())) {
            ua = ua.concat(" ").concat(this.getUserAgent());
        }
        httpPost.setHeader("User-Agent", ua);
        Map<String, Object> params = request.encode();
        StringEntity entity = new StringEntity(new Gson().toJson(params), StandardCharsets.UTF_8);
        entity.setContentType(ContentType.APPLICATION_JSON.getMimeType());
        httpPost.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        httpPost.setEntity((HttpEntity)entity);
        try {
            httpResponse = this.getHttpClient().execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            throw new TransportException("http error", e);
        }
        String requestId = "";
        if (httpResponse.getLastHeader(HEADER_REQUEST_ID) != null) {
            requestId = httpResponse.getLastHeader(HEADER_REQUEST_ID).getValue();
        }
        if ((httpStatus = httpResponse.getStatusLine()).getStatusCode() >= 400) {
            throw new UCloudException(String.format("http error, status code %d %s", httpStatus.getStatusCode(), httpStatus.getReasonPhrase()));
        }
        String content = null;
        try {
            content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new UCloudException("http error", e);
        }
        Response response = (Response)new Gson().fromJson(content, clazz);
        response.setRequestId(requestId);
        return response;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

