/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.common.credential;

import cn.ucloud.common.exception.UCloudException;
import cn.ucloud.common.request.Request;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class Credential {
    private String privateKey;
    private String publicKey;

    public Credential(String publicKey, String privateKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public String verifyAc(Request request) throws UCloudException {
        Map<String, Object> params = request.encode();
        params.put("PublicKey", this.publicKey);
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        DecimalFormat df = new DecimalFormat("#");
        df.setMaximumFractionDigits(Integer.MAX_VALUE);
        String s = "";
        for (Object key : keys) {
            s = s.concat((String)key);
            Object value = params.get(key);
            String valueStr = value instanceof Double || value instanceof Float ? df.format(value) : value.toString();
            s = s.concat(valueStr);
        }
        s = s.concat(this.privateKey);
        try {
            return this.sha1(s);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new UCloudException("sha1 error", e);
        }
    }

    public Request sign(Request request) throws UCloudException {
        request.setPublicKey(this.publicKey);
        request.setSignature(this.verifyAc(request));
        return request;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    private String sha1(String s) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return this.formatBytes2HexString(DigestUtils.sha1((String)s));
    }

    public String formatBytes2HexString(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

