/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.NonNull;
import cn.taketoday.lang.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class StreamUtils {
    public static final int BUFFER_SIZE = 8192;

    public static byte[] copyToByteArray(@Nullable InputStream in) throws IOException {
        if (in == null) {
            return Constant.EMPTY_BYTES;
        }
        return in.readAllBytes();
    }

    public static String copyToString(@Nullable InputStream in) throws IOException {
        return StreamUtils.copyToString(in, StandardCharsets.UTF_8);
    }

    public static String copyToString(@Nullable InputStream in, Charset charset) throws IOException {
        return StreamUtils.copyToString(in, charset, 8192);
    }

    public static String copyToString(@Nullable InputStream in, Charset charset, int bufferSize) throws IOException {
        int charsRead;
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(bufferSize);
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[bufferSize];
        while ((charsRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, charsRead);
        }
        return out.toString();
    }

    public static String copyToString(ByteArrayOutputStream baos, Charset charset) {
        Assert.notNull((Object)baos, "No ByteArrayOutputStream specified");
        Assert.notNull((Object)charset, "No Charset specified");
        return baos.toString(charset);
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No input byte array specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        out.write(in);
        out.flush();
    }

    public static void copy(String in, Charset charset, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No input String specified");
        Assert.notNull((Object)charset, "No Charset specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(in);
        ((Writer)writer).flush();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return StreamUtils.copy(in, out, 8192);
    }

    public static int copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        Assert.notNull((Object)in, "No InputStream specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static long copyRange(InputStream in, OutputStream out, long start, long end) throws IOException {
        int bytesRead;
        Assert.notNull((Object)in, "No InputStream specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        long skipped = in.skip(start);
        if (skipped < start) {
            throw new IOException("Skipped only " + skipped + " bytes out of " + start + " required");
        }
        long bytesToCopy = end - start + 1L;
        byte[] buffer = new byte[(int)Math.min(8192L, bytesToCopy)];
        while (bytesToCopy > 0L && (bytesRead = in.read(buffer)) != -1) {
            if ((long)bytesRead <= bytesToCopy) {
                out.write(buffer, 0, bytesRead);
                bytesToCopy -= (long)bytesRead;
                continue;
            }
            out.write(buffer, 0, (int)bytesToCopy);
            bytesToCopy = 0L;
        }
        return end - start + 1L - bytesToCopy;
    }

    public static int drain(InputStream in) throws IOException {
        return StreamUtils.drain(in, 8192);
    }

    public static int drain(InputStream in, int bufferSize) throws IOException {
        int bytesRead;
        Assert.notNull((Object)in, "No InputStream specified");
        byte[] buffer = new byte[bufferSize];
        int byteCount = 0;
        while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
            byteCount += bytesRead;
        }
        return byteCount;
    }

    public static InputStream nonClosing(InputStream in) {
        Assert.notNull((Object)in, "No InputStream specified");
        return new NonClosingInputStream(in);
    }

    public static OutputStream nonClosing(OutputStream out) {
        Assert.notNull((Object)out, "No OutputStream specified");
        return new NonClosingOutputStream(out);
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(@NonNull byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

