/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.util;

import cn.taketoday.core.ConstructorNotFoundException;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.reflect.ReflectionException;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic() && method.getDeclaringClass() != Object.class;
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    public static final String CGLIB_RENAMED_METHOD_PREFIX = "today$";
    private static final Field[] EMPTY_FIELD_ARRAY = Constant.EMPTY_FIELDS;
    private static final Method[] EMPTY_METHOD_ARRAY = Constant.EMPTY_METHODS;
    private static final Object[] EMPTY_OBJECT_ARRAY = Constant.EMPTY_OBJECTS;
    private static final ConcurrentReferenceHashMap<Class<?>, Field[]> DECLARED_FIELDS_CACHE = new ConcurrentReferenceHashMap(256);
    private static final ConcurrentReferenceHashMap<Class<?>, Method[]> DECLARED_METHODS_CACHE = new ConcurrentReferenceHashMap(256);
    private static final ConcurrentReferenceHashMap<Method, Method> interfaceMethodCache = new ConcurrentReferenceHashMap(256);

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        return ReflectionUtils.getMethodIfAvailable(clazz, methodName, paramTypes) != null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        }
        Set<Method> candidates = ReflectionUtils.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz.getName() + "." + methodName);
        }
        throw new IllegalStateException("No unique method found: " + clazz.getName() + "." + methodName);
    }

    @Nullable
    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        if (paramTypes != null) {
            return ReflectionUtils.getMethodOrNull(clazz, methodName, paramTypes);
        }
        Set<Method> candidates = ReflectionUtils.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    public static int getMethodCountForName(Class<?> clazz, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        int count = 0;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            ++count;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            count += ReflectionUtils.getMethodCountForName(ifc, methodName);
        }
        if (clazz.getSuperclass() != null) {
            count += ReflectionUtils.getMethodCountForName(clazz.getSuperclass(), methodName);
        }
        return count;
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)methodName, "Method name must not be null");
        try {
            Method method = clazz.getMethod(methodName, args);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    @Nullable
    static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String methodName) {
        Method[] methods;
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        return candidates;
    }

    public static boolean hasMethod(Class<?> clazz, Method method) {
        Class<?>[] paramTypes;
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)method, "Method must not be null");
        if (clazz == method.getDeclaringClass()) {
            return true;
        }
        String methodName = method.getName();
        return ReflectionUtils.getMethodOrNull(clazz, methodName, paramTypes = method.getParameterTypes()) != null;
    }

    public static Method getMostSpecificMethod(Method method, @Nullable Class<?> targetClass) {
        if (targetClass != null && targetClass != method.getDeclaringClass() && ReflectionUtils.isOverridable(method, targetClass)) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return targetClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method;
                    }
                }
                Method specificMethod = ReflectionUtils.findMethod(targetClass, method.getName(), method.getParameterTypes());
                return specificMethod != null ? specificMethod : method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    public static Method getInterfaceMethodIfPossible(Method method) {
        return ReflectionUtils.getInterfaceMethodIfPossible(method, null);
    }

    public static Method getInterfaceMethodIfPossible(Method method, @Nullable Class<?> targetClass) {
        if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().isInterface()) {
            return method;
        }
        Method result = interfaceMethodCache.computeIfAbsent(method, key -> ReflectionUtils.findInterfaceMethodIfPossible(key, key.getDeclaringClass(), Object.class));
        if (result == method && targetClass != null) {
            result = ReflectionUtils.findInterfaceMethodIfPossible(method, targetClass, method.getDeclaringClass());
        }
        return result;
    }

    private static Method findInterfaceMethodIfPossible(Method method, Class<?> startClass, Class<?> endClass) {
        for (Class<?> current = startClass; current != null && current != endClass; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                try {
                    return ifc.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return method;
    }

    private static boolean isOverridable(Method method, @Nullable Class<?> targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return targetClass == null || ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, null);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false)) {
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Method findFunctionalInterfaceMethod(Class clazz) {
        if (clazz.isInterface()) {
            Method found = null;
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.isDefault()) continue;
                if (found != null) {
                    throw new IllegalArgumentException("expecting exactly 1 method in " + clazz);
                }
                found = method;
            }
            return found;
        }
        throw new IllegalArgumentException(clazz + " is not an interface");
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull((Object)method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz, false)) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, @Nullable MethodFilter mf) {
        if (mf == USER_DECLARED_METHODS && clazz == Object.class) {
            return;
        }
        Method[] methods = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList<Method> methods = new ArrayList<Method>(32);
        ReflectionUtils.doWithMethods(leafClass, methods::add);
        return ReflectionUtils.toMethodArray(methods);
    }

    public static Method[] getDeclaredMethods(Class<?> targetClass) {
        return ReflectionUtils.getDeclaredMethods(targetClass, true);
    }

    private static Method[] getDeclaredMethods(Class<?> targetClass, boolean defensive) {
        Assert.notNull(targetClass, "targetClass must not be null");
        Method[] result = DECLARED_METHODS_CACHE.get(targetClass);
        if (result == null) {
            try {
                Method[] declaredMethods = targetClass.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(targetClass);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                DECLARED_METHODS_CACHE.put(targetClass, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + targetClass.getName() + "] from ClassLoader [" + targetClass.getClassLoader() + "]", ex);
            }
        }
        return result.length == 0 || !defensive ? result : (Method[])result.clone();
    }

    @Nullable
    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        return ReflectionUtils.getUniqueDeclaredMethods(leafClass, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass, @Nullable MethodFilter mf) {
        ArrayList<Method> methods = new ArrayList<Method>(32);
        ReflectionUtils.doWithMethods(leafClass, method -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods) {
                if (!method.getName().equals(existingMethod.getName()) || method.getParameterCount() != existingMethod.getParameterCount() || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                methods.add(method);
            }
        }, mf);
        return ReflectionUtils.toMethodArray(methods);
    }

    public static boolean isEqualsMethod(@Nullable Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(@Nullable Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterCount() == 0;
    }

    public static boolean isToStringMethod(@Nullable Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterCount() == 0;
    }

    public static boolean isObjectMethod(@Nullable Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method) || ReflectionUtils.isHashCodeMethod(method) || ReflectionUtils.isToStringMethod(method));
    }

    public static boolean isFinalizeMethod(@Nullable Method method) {
        return method != null && method.getName().equals("finalize") && method.getParameterCount() == 0;
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            return i > CGLIB_RENAMED_METHOD_PREFIX.length() && i < name.length() - 1 && name.charAt(i) == '$';
        }
        return false;
    }

    public static Method makeAccessible(Method method) {
        Assert.notNull((Object)method, "method must not be null");
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method[] toMethodArray(Collection<Method> collection) {
        return CollectionUtils.isEmpty(collection) ? EMPTY_METHOD_ARRAY : collection.toArray(new Method[collection.size()]);
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, @Nullable FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] result = DECLARED_FIELDS_CACHE.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredFields();
                DECLARED_FIELDS_CACHE.put(clazz, result.length == 0 ? EMPTY_FIELD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    public static void shallowCopyFieldState(Object src, Object dest) {
        Assert.notNull(src, "Source for field copy cannot be null");
        Assert.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), field -> ReflectionUtils.copyField(field, src, dest), COPYABLE_FIELDS);
    }

    public static void copyField(Field field, Object src, Object dest) {
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, dest, ReflectionUtils.getField(field, src));
    }

    public static Field makeAccessible(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
        return field;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static Field[] toFieldArray(Collection<Field> fields) {
        return CollectionUtils.isEmpty(fields) ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[0]);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> targetClass, Class<?> ... parameterTypes) {
        return ReflectionUtils.makeAccessible(ReflectionUtils.getConstructor(targetClass, parameterTypes));
    }

    public static <T> Constructor<T> makeAccessible(Constructor<T> constructor) {
        Assert.notNull(constructor, "constructor must not be null");
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        return ReflectionUtils.getConstructorIfAvailable(clazz, paramTypes) != null;
    }

    @Nullable
    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        Assert.notNull(type, "Class must not be null");
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructorNotFoundException(type, parameterTypes, e);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void clearCache() {
        DECLARED_FIELDS_CACHE.clear();
        DECLARED_METHODS_CACHE.clear();
    }

    public static Field obtainField(Class<?> clazz, String name) {
        Field field = ReflectionUtils.findField(clazz, name);
        if (field == null) {
            throw new ReflectionException("No such field named: " + name + " in class: " + clazz.getName());
        }
        return field;
    }

    public static Method obtainMethod(Class<?> targetClass, String methodName, Class<?> ... parameterTypes) {
        Method declaredMethod = ReflectionUtils.findMethod(targetClass, methodName, parameterTypes);
        if (declaredMethod == null) {
            throw new ReflectionException("No such method named: " + methodName + " in class: " + targetClass.getName());
        }
        return declaredMethod;
    }

    @Nullable
    public static Method findMethodWithMinimalParameters(Class<?> clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = ReflectionUtils.findMethodWithMinimalParameters(clazz.getMethods(), methodName);
        if (targetMethod == null) {
            targetMethod = ReflectionUtils.findDeclaredMethodWithMinimalParameters(clazz, methodName);
        }
        return targetMethod;
    }

    @Nullable
    public static Method findDeclaredMethodWithMinimalParameters(Class<?> clazz, String methodName) throws IllegalArgumentException {
        Method targetMethod = ReflectionUtils.findMethodWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz.getSuperclass() != null) {
            targetMethod = ReflectionUtils.findDeclaredMethodWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    @Nullable
    public static Method findMethodWithMinimalParameters(Method[] methods, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            int numParams = method.getParameterCount();
            if (targetMethod == null || numParams < targetMethod.getParameterCount()) {
                targetMethod = method;
                numMethodsFoundWithCurrentMinimumArgs = 1;
                continue;
            }
            if (method.isBridge() || targetMethod.getParameterCount() != numParams) continue;
            if (targetMethod.isBridge()) {
                targetMethod = method;
                continue;
            }
            ++numMethodsFoundWithCurrentMinimumArgs;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with the least number of parameters but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    @Nullable
    public static Method getReadMethod(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        Class<?> type = field.getType();
        String propertyName = field.getName();
        return ReflectionUtils.getReadMethod(field.getDeclaringClass(), type, propertyName);
    }

    @Nullable
    public static Method getReadMethod(Class<?> declaredClass, @Nullable Class<?> type, String name) {
        String getterName = ReflectionUtils.getterPropertyName(name, type);
        return ReflectionUtils.findMethod(declaredClass, getterName, Constant.EMPTY_CLASSES);
    }

    @Nullable
    public static Method getWriteMethod(Field field) {
        Assert.notNull((Object)field, "field must not be null");
        Class<?> type = field.getType();
        String propertyName = field.getName();
        return ReflectionUtils.getWriteMethod(field.getDeclaringClass(), type, propertyName);
    }

    @Nullable
    public static Method getWriteMethod(Class<?> declaredClass, @Nullable Class<?> type, String name) {
        String setterName = ReflectionUtils.setterPropertyName(name, type);
        if (type == null) {
            return ReflectionUtils.getMethodIfAvailable(declaredClass, setterName, null);
        }
        return ReflectionUtils.findMethod(declaredClass, setterName, type);
    }

    static String setterPropertyName(String name, @Nullable Class<?> type) {
        if (type == Boolean.TYPE && name.startsWith("is")) {
            name = name.substring(2);
        }
        return "set".concat(StringUtils.capitalize(name));
    }

    static String getterPropertyName(String name, @Nullable Class<?> type) {
        if (type == Boolean.TYPE) {
            if (name.startsWith("is")) {
                return name;
            }
            return "is".concat(StringUtils.capitalize(name));
        }
        return "get".concat(StringUtils.capitalize(name));
    }

    @Nullable
    public static String getPropertyName(@Nullable Method readMethod, @Nullable Method writeMethod) {
        int index;
        if (readMethod != null) {
            int index2 = readMethod.getName().indexOf("get");
            index2 = index2 != -1 ? (index2 += 3) : ((index2 = readMethod.getName().indexOf("is")) != -1 ? (index2 += 2) : 0);
            return StringUtils.uncapitalize(readMethod.getName().substring(index2));
        }
        if (writeMethod != null && (index = writeMethod.getName().indexOf("set")) != -1) {
            return StringUtils.uncapitalize(writeMethod.getName().substring(index += 3));
        }
        return null;
    }

    public static int getParameterIndex(Parameter parameter) {
        int i;
        Executable executable = parameter.getDeclaringExecutable();
        Parameter[] allParams = executable.getParameters();
        for (i = 0; i < allParams.length; ++i) {
            if (parameter != allParams[i]) continue;
            return i;
        }
        for (i = 0; i < allParams.length; ++i) {
            if (!parameter.equals(allParams[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("Given parameter [" + parameter + "] does not match any parameter in the declaring executable");
    }

    public static Parameter getParameter(Executable executable, int parameterIndex) {
        Assert.notNull((Object)executable, "Executable must not be null");
        Parameter[] parameters = executable.getParameters();
        if (parameterIndex < 0 || parameterIndex >= parameters.length) {
            throw new IllegalArgumentException("parameter index is illegal");
        }
        return parameters[parameterIndex];
    }

    public static <T> T newInstance(String beanClassName) throws ClassNotFoundException {
        return ReflectionUtils.newInstance(ClassUtils.resolveClassName(beanClassName, null));
    }

    public static <T> T newInstance(Class<T> type) {
        return ReflectionUtils.newInstance(type, Constant.EMPTY_CLASSES, null);
    }

    public static <T> T newInstance(Class<T> type, Class[] parameterTypes, Object[] args) {
        return ReflectionUtils.invokeConstructor(ReflectionUtils.getConstructor(type, parameterTypes), args);
    }

    @Nullable
    public static ProtectionDomain getProtectionDomain(Class<?> source) {
        if (source == null) {
            return null;
        }
        return source.getProtectionDomain();
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);

        default public MethodFilter and(MethodFilter next) {
            Assert.notNull((Object)next, "Next MethodFilter must not be null");
            return method -> this.matches(method) && next.matches(method);
        }
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);

        default public FieldFilter and(FieldFilter next) {
            Assert.notNull((Object)next, "Next FieldFilter must not be null");
            return field -> this.matches(field) && next.matches(field);
        }
    }
}

