/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.logging;

import cn.taketoday.logging.JavaLoggingLogger;
import cn.taketoday.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

final class JavaLoggingFactory
extends LoggerFactory {
    JavaLoggingFactory() {
    }

    @Override
    protected JavaLoggingLogger createLogger(String name) {
        Logger logger = Logger.getLogger(name);
        return new JavaLoggingLogger(logger, logger.isLoggable(Level.FINER));
    }

    static {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("logging.properties");
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();){
                LogManager.getLogManager().readConfiguration(inputStream);
            }
            catch (IOException | SecurityException e) {
                System.err.println("Can't load config file 'logging.properties'");
                e.printStackTrace();
            }
        }
    }
}

