/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.lang;

import cn.taketoday.lang.Nullable;
import java.util.Objects;

public record Version(int major, int minor, int micro, String type, int step, @Nullable String extension, String implementationVersion) {
    public static final String Draft = "Draft";
    public static final String Alpha = "Alpha";
    public static final String Beta = "Beta";
    public static final String RELEASE = "RELEASE";
    public static final Version instance;

    static Version parse(String implementationVersion) {
        String type;
        String extension = null;
        int step = 0;
        String[] split = implementationVersion.split("-");
        if (split.length == 1) {
            type = RELEASE;
        } else {
            String[] typeSplit;
            if (split.length == 3) {
                extension = split[2];
            }
            if ((typeSplit = (type = split[1]).split("\\.")).length == 2) {
                type = typeSplit[0];
                step = Integer.parseInt(typeSplit[1]);
            }
        }
        String ver = split[0];
        String[] verSplit = ver.split("\\.");
        int major = Integer.parseInt(verSplit[0]);
        int minor = Integer.parseInt(verSplit[1]);
        int micro = Integer.parseInt(verSplit[2]);
        return new Version(major, minor, micro, type, step, extension, implementationVersion);
    }

    @Override
    public String toString() {
        return "v" + this.implementationVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.implementationVersion, version.implementationVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.implementationVersion);
    }

    public static Version get() {
        return instance;
    }

    static {
        Package pkg = Version.class.getPackage();
        String implementationVersion = pkg.getImplementationVersion();
        if (implementationVersion != null) {
            instance = Version.parse(implementationVersion);
        } else {
            instance = new Version(0, 0, 0, RELEASE, 0, null, "Unknown");
            System.err.println("cn.taketoday.lang.Version cannot get 'implementationVersion' in manifest.");
        }
    }
}

