/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.lang;

import cn.taketoday.core.DefaultMultiValueMap;
import cn.taketoday.core.MultiValueMap;
import cn.taketoday.core.annotation.AnnotationAwareOrderComparator;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.LogMessage;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import cn.taketoday.util.ReflectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TodayStrategies {
    private static final Logger log;
    public static final String STRATEGIES_LOCATION = "META-INF/today-strategies.properties";
    static final ConcurrentReferenceHashMap<ClassLoader, Map<String, TodayStrategies>> strategiesCache;
    private static final String PROPERTIES_RESOURCE_LOCATION = "today.properties";
    private static final Properties localProperties;
    private final ClassLoader classLoader;
    private final Map<String, List<String>> strategies;

    public static boolean getFlag(String key) {
        String property = TodayStrategies.getProperty(key);
        return Boolean.parseBoolean(property);
    }

    public static boolean getFlag(String key, boolean defaultFlag) {
        String property = TodayStrategies.getProperty(key);
        return StringUtils.isEmpty(property) ? defaultFlag : Boolean.parseBoolean(property);
    }

    public static void setFlag(String key) {
        localProperties.put(key, Boolean.TRUE.toString());
    }

    public static void setProperty(String key, @Nullable String value) {
        if (value != null) {
            localProperties.setProperty(key, value);
        } else {
            localProperties.remove(key);
        }
    }

    @Nullable
    public static String getProperty(String key) {
        String value = localProperties.getProperty(key);
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (Throwable ex) {
                System.err.println("Could not retrieve system property '" + key + "': " + ex);
            }
        }
        return value;
    }

    public static String getProperty(String key, String def) {
        String property = TodayStrategies.getProperty(key);
        if (property == null) {
            property = def;
        }
        return property;
    }

    @Nullable
    public static Integer getInteger(String key) {
        return TodayStrategies.getInteger(key, null);
    }

    public static int getInt(String key, int val) {
        Integer result = TodayStrategies.getInteger(key, null);
        return result == null ? Integer.valueOf(val) : result;
    }

    @Nullable
    public static Integer getInteger(String key, @Nullable Integer val) {
        try {
            String v = TodayStrategies.getProperty(key);
            if (v != null) {
                try {
                    return Integer.decode(v);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return val;
    }

    public static Long getLong(String nm) {
        return TodayStrategies.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? Long.valueOf(val) : result;
    }

    public static Long getLong(String nm, Long val) {
        try {
            String v = System.getProperty(nm);
            if (v != null) {
                try {
                    return Long.decode(v);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return val;
    }

    protected TodayStrategies(@Nullable ClassLoader classLoader, Map<String, List<String>> strategies) {
        this.classLoader = classLoader;
        this.strategies = strategies;
    }

    public static void readStrategies(MultiValueMap<String, String> strategies, String strategyKey, String value) {
        List<String> strategyValues = StringUtils.splitAsList(value);
        for (String strategyValue : strategyValues) {
            if (!StringUtils.isNotEmpty(strategyValue = strategyValue.trim())) continue;
            strategies.add(strategyKey, strategyValue);
        }
    }

    public static void readStrategies(MultiValueMap<String, String> strategies, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            TodayStrategies.readStrategies(strategies, key.toString(), value.toString());
        }
    }

    public <T> List<T> load(Class<T> strategyType) {
        return this.load(strategyType, (ArgumentResolver)null, null);
    }

    public <T> List<T> load(Class<T> strategyType, @Nullable ArgumentResolver argumentResolver) {
        return this.load(strategyType, argumentResolver, null);
    }

    public <T> List<T> load(Class<T> strategyType, Instantiator instantiator) {
        return this.load(strategyType, instantiator, null);
    }

    public <T> List<T> load(Class<T> strategyType, @Nullable FailureHandler failureHandler) {
        return this.load(strategyType, (ArgumentResolver)null, failureHandler);
    }

    public <T> List<T> load(Class<T> strategyType, @Nullable ArgumentResolver argumentResolver, @Nullable FailureHandler failureHandler) {
        DefaultInstantiator instantiator = new DefaultInstantiator(argumentResolver);
        return this.load(strategyType, instantiator, failureHandler);
    }

    public <T> List<T> load(Class<T> strategyType, Instantiator instantiator, @Nullable FailureHandler failureHandler) {
        Assert.notNull(strategyType, "'strategyType' is required");
        Assert.notNull((Object)instantiator, "'instantiator' is required");
        List<String> implementationNames = this.getStrategyNames(strategyType);
        if (log.isTraceEnabled()) {
            log.trace("Loaded [{}] names: {}", (Object)strategyType.getName(), (Object)implementationNames);
        }
        ArrayList<T> result = new ArrayList<T>(implementationNames.size());
        if (failureHandler == null) {
            failureHandler = FailureHandler.throwing();
        }
        for (String implementationName : implementationNames) {
            T strategy = this.instantiateStrategy(implementationName, strategyType, instantiator, failureHandler);
            if (strategy == null) continue;
            result.add(strategy);
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    private List<String> getStrategyNames(String strategyKey) {
        return this.strategies.getOrDefault(strategyKey, Collections.emptyList());
    }

    private List<String> getStrategyNames(Class<?> strategyType) {
        return this.getStrategyNames(strategyType.getName());
    }

    @Nullable
    protected <T> T instantiateStrategy(String implementationName, Class<T> type, Instantiator instantiator, FailureHandler failureHandler) {
        try {
            Class implementation = ClassUtils.forName(implementationName, this.classLoader);
            if (!type.isAssignableFrom(implementation)) {
                throw new IllegalArgumentException("Class [%s] is not assignable to strategy type [%s]".formatted(implementationName, type.getName()));
            }
            return instantiator.instantiate(implementation);
        }
        catch (Throwable ex) {
            failureHandler.handleFailure(type, implementationName, ex);
            return null;
        }
    }

    @Nullable
    public static String getFirst(String strategyKey) {
        return CollectionUtils.firstElement(TodayStrategies.findNames(strategyKey, null));
    }

    public static <T> T getFirst(Class<T> strategyClass, @Nullable Supplier<T> defaultValue) {
        T first = CollectionUtils.firstElement(TodayStrategies.find(strategyClass, (ClassLoader)null));
        if (first == null && defaultValue != null) {
            return defaultValue.get();
        }
        return first;
    }

    public static <T> List<T> find(Class<T> strategyClass) {
        return TodayStrategies.find(strategyClass, (ClassLoader)null);
    }

    public static <T> List<T> find(Class<T> strategyType, @Nullable ClassLoader classLoader) {
        return TodayStrategies.forDefaultResourceLocation(classLoader).load(strategyType);
    }

    public static <T> List<T> find(Class<T> strategyType, @Nullable ClassLoader classLoader, Instantiator instantiator) {
        return TodayStrategies.forDefaultResourceLocation(classLoader).load(strategyType, instantiator);
    }

    public static <T> List<T> find(Class<T> strategyType, Instantiator instantiator) {
        return TodayStrategies.forDefaultResourceLocation().load(strategyType, instantiator);
    }

    public static List<String> findNames(Class<?> strategyType) {
        return TodayStrategies.findNames(strategyType, null);
    }

    public static List<String> findNames(Class<?> strategyType, @Nullable ClassLoader classLoader) {
        return TodayStrategies.forDefaultResourceLocation(classLoader).getStrategyNames(strategyType);
    }

    public static List<String> findNames(String strategyKey) {
        return TodayStrategies.findNames(strategyKey, null);
    }

    public static List<String> findNames(String strategyKey, @Nullable ClassLoader classLoader) {
        return TodayStrategies.forDefaultResourceLocation(classLoader).getStrategyNames(strategyKey);
    }

    public static TodayStrategies forDefaultResourceLocation() {
        return TodayStrategies.forDefaultResourceLocation(null);
    }

    public static TodayStrategies forDefaultResourceLocation(@Nullable ClassLoader classLoader) {
        return TodayStrategies.forLocation(STRATEGIES_LOCATION, classLoader);
    }

    public static TodayStrategies forLocation(String resourceLocation) {
        return TodayStrategies.forLocation(resourceLocation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TodayStrategies forLocation(String resourceLocation, @Nullable ClassLoader classLoader) {
        TodayStrategies todayStrategies;
        Map<String, TodayStrategies> loaders;
        Assert.hasText(resourceLocation, "'resourceLocation' must not be empty");
        if (classLoader == null) {
            classLoader = TodayStrategies.class.getClassLoader();
        }
        if ((loaders = strategiesCache.get(classLoader)) == null) {
            ConcurrentReferenceHashMap<ClassLoader, Map<String, TodayStrategies>> concurrentReferenceHashMap = strategiesCache;
            synchronized (concurrentReferenceHashMap) {
                loaders = strategiesCache.get(classLoader);
                if (loaders == null) {
                    loaders = new ConcurrentReferenceHashMap<String, TodayStrategies>();
                    strategiesCache.put(classLoader, loaders);
                }
            }
        }
        if ((todayStrategies = loaders.get(resourceLocation)) == null) {
            Map<String, TodayStrategies> map = loaders;
            synchronized (map) {
                todayStrategies = loaders.get(resourceLocation);
                if (todayStrategies == null) {
                    todayStrategies = new TodayStrategies(classLoader, TodayStrategies.loadResource(classLoader, resourceLocation));
                    loaders.put(resourceLocation, todayStrategies);
                }
            }
        }
        return todayStrategies;
    }

    protected static Map<String, List<String>> loadResource(ClassLoader classLoader, String resourceLocation) {
        DefaultMultiValueMap<String, String> strategies = MultiValueMap.fromLinkedHashMap();
        try {
            log.debug("Detecting strategies location '{}'", (Object)resourceLocation);
            Enumeration<URL> urls = classLoader.getResources(resourceLocation);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Properties properties = new Properties();
                try (InputStream inputStream = url.openStream();){
                    properties.load(inputStream);
                }
                log.debug("Reading strategies file '{}'", (Object)url);
                TodayStrategies.readStrategies(strategies, properties);
            }
            strategies.replaceAll(TodayStrategies::toDistinctUnmodifiableList);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Unable to load strategies from location [" + resourceLocation + "]", ex);
        }
        return Collections.unmodifiableMap(strategies);
    }

    private static List<String> toDistinctUnmodifiableList(String strategyType, List<String> implementations) {
        return implementations.stream().distinct().toList();
    }

    static {
        block8: {
            log = LoggerFactory.getLogger(TodayStrategies.class);
            strategiesCache = new ConcurrentReferenceHashMap();
            localProperties = new Properties();
            try {
                URL url;
                ClassLoader cl = TodayStrategies.class.getClassLoader();
                URL uRL = url = cl != null ? cl.getResource(PROPERTIES_RESOURCE_LOCATION) : ClassLoader.getSystemResource(PROPERTIES_RESOURCE_LOCATION);
                if (url == null) break block8;
                try (InputStream is = url.openStream();){
                    localProperties.load(is);
                }
            }
            catch (IOException ex) {
                System.err.println("Could not load 'today.properties' file from local classpath: " + ex);
            }
        }
    }

    @FunctionalInterface
    public static interface ArgumentResolver {
        @Nullable
        public <T> T resolve(Class<T> var1);

        default public <T> ArgumentResolver and(Class<T> type, T value) {
            return this.and(ArgumentResolver.of(type, value));
        }

        default public <T> ArgumentResolver andSupplied(Class<T> type, Supplier<T> valueSupplier) {
            return this.and(ArgumentResolver.ofSupplied(type, valueSupplier));
        }

        default public ArgumentResolver and(ArgumentResolver argumentResolver) {
            return ArgumentResolver.from(type -> {
                Object resolved = this.resolve((Class)type);
                return resolved != null ? resolved : argumentResolver.resolve((Class)type);
            });
        }

        public static ArgumentResolver none() {
            return ArgumentResolver.from(type -> null);
        }

        public static <T> ArgumentResolver of(Class<T> type, T value) {
            return ArgumentResolver.ofSupplied(type, () -> value);
        }

        public static <T> ArgumentResolver ofSupplied(Class<T> type, Supplier<T> valueSupplier) {
            return ArgumentResolver.from(candidateType -> candidateType.equals(type) ? valueSupplier.get() : null);
        }

        public static ArgumentResolver from(final Function<Class<?>, Object> function) {
            return new ArgumentResolver(){

                @Override
                public <T> T resolve(Class<T> type) {
                    return (T)function.apply(type);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void handleFailure(Class<?> var1, String var2, Throwable var3);

        public static FailureHandler throwing() {
            return FailureHandler.throwing(IllegalArgumentException::new);
        }

        public static FailureHandler throwing(BiFunction<String, Throwable, ? extends RuntimeException> exceptionFactory) {
            return FailureHandler.handleMessage((messageSupplier, failure) -> {
                throw (RuntimeException)exceptionFactory.apply((String)messageSupplier.get(), (Throwable)failure);
            });
        }

        public static FailureHandler logging(Logger logger) {
            return FailureHandler.handleMessage((messageSupplier, failure) -> logger.trace(LogMessage.from(messageSupplier), (Throwable)failure));
        }

        public static FailureHandler handleMessage(BiConsumer<Supplier<String>, Throwable> messageHandler) {
            return (strategyType, implementationName, failure) -> {
                Supplier<String> messageSupplier = () -> "Unable to instantiate strategy class [%s] for strategy type [%s]".formatted(implementationName, strategyType.getName());
                messageHandler.accept(messageSupplier, failure);
            };
        }
    }

    public static interface Instantiator {
        public <T> T instantiate(Class<T> var1) throws Exception;
    }

    static final class DefaultInstantiator
    implements Instantiator {
        @Nullable
        private final ArgumentResolver argumentResolver;

        DefaultInstantiator(@Nullable ArgumentResolver argumentResolver) {
            this.argumentResolver = argumentResolver;
        }

        @Override
        public <T> T instantiate(Class<T> implementation) throws Exception {
            Constructor<?> constructor = DefaultInstantiator.findConstructor(implementation);
            if (constructor == null) {
                throw new IllegalStateException("Class [%s] has no suitable constructor".formatted(implementation.getName()));
            }
            Class<?>[] types = constructor.getParameterTypes();
            Object[] args = new Object[types.length];
            if (this.argumentResolver != null) {
                int i = 0;
                for (Class<?> type : types) {
                    args[i++] = this.argumentResolver.resolve(type);
                }
            }
            ReflectionUtils.makeAccessible(constructor);
            return (T)constructor.newInstance(args);
        }

        @Nullable
        private static Constructor<?> findConstructor(Class<?> implementationClass) {
            Constructor<?> constructor = DefaultInstantiator.findSingleConstructor(implementationClass.getConstructors());
            if (constructor == null && (constructor = DefaultInstantiator.findSingleConstructor(implementationClass.getDeclaredConstructors())) == null) {
                constructor = DefaultInstantiator.findDeclaredConstructor(implementationClass);
            }
            return constructor;
        }

        @Nullable
        private static Constructor<?> findSingleConstructor(Constructor<?>[] constructors) {
            return constructors.length == 1 ? constructors[0] : null;
        }

        @Nullable
        private static Constructor<?> findDeclaredConstructor(Class<?> implementationClass) {
            try {
                return implementationClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
    }
}

