/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.support;

import cn.taketoday.core.TypeDescriptor;
import cn.taketoday.core.conversion.ConversionException;
import cn.taketoday.core.conversion.ConversionService;
import cn.taketoday.core.conversion.support.DefaultConversionService;
import cn.taketoday.expression.TypeConverter;
import cn.taketoday.expression.spel.SpelEvaluationException;
import cn.taketoday.expression.spel.SpelMessage;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.util.function.Supplier;

public class StandardTypeConverter
implements TypeConverter {
    private final Supplier<ConversionService> conversionService;

    public StandardTypeConverter() {
        this.conversionService = DefaultConversionService::getSharedInstance;
    }

    public StandardTypeConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.conversionService = () -> conversionService;
    }

    public StandardTypeConverter(Supplier<ConversionService> conversionService) {
        Assert.notNull(conversionService, "Supplier must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public boolean canConvert(@Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.get().canConvert(sourceType, targetType);
    }

    @Override
    @Nullable
    public Object convertValue(@Nullable Object value, @Nullable TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.conversionService.get().convert(value, sourceType, targetType);
        }
        catch (ConversionException ex) {
            throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, sourceType != null ? sourceType.toString() : (value != null ? value.getClass().getName() : "null"), targetType.toString());
        }
    }
}

