/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.expression.spel.ast;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.core.CodeFlow;
import cn.taketoday.expression.EvaluationException;
import cn.taketoday.expression.TypedValue;
import cn.taketoday.expression.spel.ExpressionState;
import cn.taketoday.expression.spel.ast.SpelNodeImpl;
import cn.taketoday.expression.spel.ast.TypeCode;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.lang.reflect.Array;

public class TypeReference
extends SpelNodeImpl {
    private final int dimensions;
    @Nullable
    private transient Class<?> type;

    public TypeReference(int startPos, int endPos, SpelNodeImpl qualifiedId) {
        this(startPos, endPos, qualifiedId, 0);
    }

    public TypeReference(int startPos, int endPos, SpelNodeImpl qualifiedId, int dims) {
        super(startPos, endPos, qualifiedId);
        this.dimensions = dims;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        TypeCode tc;
        String typeName = (String)this.children[0].getValueInternal(state).getValue();
        Assert.state(typeName != null, "No type name");
        if (!typeName.contains(".") && Character.isLowerCase(typeName.charAt(0)) && (tc = TypeCode.valueOf(typeName.toUpperCase())) != TypeCode.OBJECT) {
            Class<?> clazz = this.makeArrayIfNecessary(tc.getType());
            this.exitTypeDescriptor = "Ljava/lang/Class";
            this.type = clazz;
            return new TypedValue(clazz);
        }
        Class<?> clazz = state.findType(typeName);
        clazz = this.makeArrayIfNecessary(clazz);
        this.exitTypeDescriptor = "Ljava/lang/Class";
        this.type = clazz;
        return new TypedValue(clazz);
    }

    private Class<?> makeArrayIfNecessary(Class<?> clazz) {
        if (this.dimensions != 0) {
            for (int i = 0; i < this.dimensions; ++i) {
                Object array = Array.newInstance(clazz, 0);
                clazz = array.getClass();
            }
        }
        return clazz;
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("T(");
        sb.append(this.getChild(0).toStringAST());
        sb.append("[]".repeat(Math.max(0, this.dimensions)));
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        Class<?> type = this.type;
        Assert.state(type != null, "No type available");
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
            } else if (type == Byte.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
            } else if (type == Character.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
            } else if (type == Double.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
            } else if (type == Float.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
            } else if (type == Integer.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
            } else if (type == Long.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
            } else if (type == Short.TYPE) {
                mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
            }
        } else {
            mv.visitLdcInsn(Type.fromClass(this.type));
        }
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

