/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.core.annotation.MergedAnnotation;
import cn.taketoday.core.annotation.MergedAnnotations;
import cn.taketoday.core.type.MethodMetadata;
import cn.taketoday.core.type.classreading.MergedAnnotationReadingVisitor;
import cn.taketoday.core.type.classreading.SimpleAnnotationMetadata;
import cn.taketoday.core.type.classreading.SimpleMethodMetadataReadingVisitor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ObjectUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;

final class SimpleAnnotationMetadataReadingVisitor
extends ClassVisitor {
    @Nullable
    private final ClassLoader classLoader;
    private String className = "";
    private int access;
    @Nullable
    private String superClassName;
    @Nullable
    private LinkedHashSet<String> interfaceNames;
    @Nullable
    private String enclosingClassName;
    private boolean independentInnerClass;
    @Nullable
    private ArrayList<MergedAnnotation<?>> annotations;
    @Nullable
    private LinkedHashSet<String> memberClassNames;
    @Nullable
    private LinkedHashSet<MethodMetadata> declaredMethods;
    @Nullable
    private SimpleAnnotationMetadata metadata;
    @Nullable
    private Source source;

    SimpleAnnotationMetadataReadingVisitor(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void visit(int version, int access, String name, String signature, @Nullable String supername, String[] interfaces) {
        this.className = this.toClassName(name);
        this.access = access;
        if (supername != null && !this.isInterface(access)) {
            this.superClassName = this.toClassName(supername);
        }
        if (ObjectUtils.isNotEmpty(interfaces)) {
            if (this.interfaceNames == null) {
                this.interfaceNames = new LinkedHashSet(interfaces.length);
            }
            for (String anInterface : interfaces) {
                this.interfaceNames.add(this.toClassName(anInterface));
            }
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = this.toClassName(owner);
    }

    @Override
    public void visitInnerClass(String name, @Nullable String outerName, String innerName, int access) {
        if (outerName != null) {
            String className = this.toClassName(name);
            String outerClassName = this.toClassName(outerName);
            if (this.className.equals(className)) {
                this.enclosingClassName = outerClassName;
                this.independentInnerClass = (access & 8) != 0;
            } else if (this.className.equals(outerClassName)) {
                if (this.memberClassNames == null) {
                    this.memberClassNames = new LinkedHashSet(4);
                }
                this.memberClassNames.add(className);
            }
        }
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        return MergedAnnotationReadingVisitor.get(this.classLoader, this.getSource(), descriptor, visible, this.annotations::add);
    }

    @Override
    @Nullable
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isBridge(access) || "<init>".equals(name)) {
            return null;
        }
        if (this.declaredMethods == null) {
            this.declaredMethods = new LinkedHashSet();
        }
        return new SimpleMethodMetadataReadingVisitor(this.classLoader, this.className, access, name, descriptor, this.declaredMethods::add);
    }

    @Override
    public void visitEnd() {
        this.metadata = new SimpleAnnotationMetadata(this.className, this.access, this.enclosingClassName, this.superClassName, this.independentInnerClass, this.interfaceNames, this.memberClassNames, this.declaredMethods, MergedAnnotations.valueOf(this.annotations));
    }

    public SimpleAnnotationMetadata getMetadata() {
        Assert.state(this.metadata != null, "AnnotationMetadata not initialized");
        return this.metadata;
    }

    private Source getSource() {
        Source source = this.source;
        if (source == null) {
            this.source = source = new Source(this.className);
        }
        return source;
    }

    private String toClassName(String name) {
        return ClassUtils.convertResourcePathToClassName(name);
    }

    private boolean isBridge(int access) {
        return (access & 0x40) != 0;
    }

    private boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    private record Source(String className) {
        @Override
        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.className.equals(((Source)obj).className);
        }

        @Override
        public String toString() {
            return this.className;
        }
    }
}

