/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core.type.classreading;

import cn.taketoday.core.io.Resource;
import cn.taketoday.core.io.ResourceLoader;
import cn.taketoday.core.type.classreading.MetadataReader;
import cn.taketoday.core.type.classreading.SimpleMetadataReaderFactory;
import cn.taketoday.util.ConcurrentReferenceHashMap;
import java.io.IOException;

public class ConcurrentReferenceCachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    private final ConcurrentReferenceHashMap<Resource, MetadataReader> cache = new ConcurrentReferenceHashMap();

    public ConcurrentReferenceCachingMetadataReaderFactory() {
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public ConcurrentReferenceCachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        MetadataReader metadataReader = this.cache.get(resource);
        if (metadataReader == null) {
            metadataReader = this.createMetadataReader(resource);
            this.cache.put(resource, metadataReader);
        }
        return metadataReader;
    }

    protected MetadataReader createMetadataReader(Resource resource) throws IOException {
        return super.getMetadataReader(resource);
    }

    public void clearCache() {
        this.cache.clear();
    }
}

